/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.QteLineDocProvider;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public class QteTotalLineDocProvider
extends QteLineDocProvider {
    public QteTotalLineDocProvider(QteLineDocProvider.TypePoidsDocProvider t) {
        super(t);
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        SQLTable table = row.getTable();
        Collection<? extends SQLRowAccessor> cols = row.getReferentRows(table.getTable(String.valueOf(table.getName()) + "_ELEMENT"));
        BigDecimal total = BigDecimal.ZERO;
        for (SQLRowAccessor sQLRowAccessor : cols) {
            if (sQLRowAccessor.getTable().contains("NIVEAU") && sQLRowAccessor.getInt("NIVEAU") != 1) continue;
            total = total.add(this.getPoidsFromRow(sQLRowAccessor));
        }
        return total;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.poids.net.lines.sum", new QteTotalLineDocProvider(QteLineDocProvider.TypePoidsDocProvider.POIDS_NET));
        SpreadSheetCellValueProviderManager.put("sales.poids.brut.lines.sum", new QteTotalLineDocProvider(QteLineDocProvider.TypePoidsDocProvider.POIDS_BRUT));
    }
}

