/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationDoc.AbstractJOOReportsSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.GestionDevise;

public class RelanceSheet
extends AbstractJOOReportsSheet {
    private SQLRow rowRelance;
    public static final String TEMPLATE_ID = "Relance";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationRelance";

    @Override
    public String getDefaultTemplateID() {
        return TEMPLATE_ID;
    }

    @Override
    public String getDefaultLocationProperty() {
        return TEMPLATE_PROPERTY_NAME;
    }

    @Override
    protected Map<String, Object> createMap() {
        SQLRow clientRowNX;
        HashMap<String, Object> map = new HashMap<String, Object>();
        SQLRow rowSoc = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowSocAdresse = rowSoc.getForeignRow("ID_ADRESSE_COMMON");
        SQLRow rowUser = rowSoc.getTable().getDBRoot().findTable("USER_COMMON").getRow(UserManager.getUser().getId());
        map.put("UserName", rowUser.getString("NOM"));
        map.put("UserFirstName", rowUser.getString("PRENOM"));
        if (rowUser.getTable().contains("MAIL")) {
            map.put("UserMail", rowUser.getString("MAIL"));
        }
        if (rowUser.getTable().contains("TEL")) {
            map.put("UserTel", rowUser.getString("TEL"));
        }
        map.put("SocieteType", rowSoc.getString("TYPE"));
        map.put("SocieteTel", rowSoc.getString("NUM_TEL"));
        map.put("SocieteFax", rowSoc.getString("NUM_FAX"));
        map.put("SocieteRCS", rowSoc.getString("RCS"));
        map.put("SocieteSiret", rowSoc.getString("NUM_SIRET"));
        map.put("SocieteAPE", rowSoc.getString("NUM_APE"));
        map.put("SocieteCapital", GestionDevise.currencyToString(rowSoc.getBigDecimal("CAPITAL")));
        map.put("SocieteNom", rowSoc.getString("NOM"));
        map.put("SocieteAdresse", rowSocAdresse.getString("RUE"));
        map.put("SocieteCodePostal", rowSocAdresse.getString("CODE_POSTAL"));
        String ville = rowSocAdresse.getString("VILLE");
        Object cedex = rowSocAdresse.getObject("CEDEX");
        boolean hasCedex = rowSocAdresse.getBoolean("HAS_CEDEX");
        if (hasCedex) {
            ville = String.valueOf(ville) + " CEDEX";
            if (cedex != null && cedex.toString().trim().length() > 0) {
                ville = String.valueOf(ville) + " " + cedex.toString().trim();
            }
        }
        map.put("SocieteVille", ville);
        SQLRow rowClient = clientRowNX = this.rowRelance.getForeignRow("ID_CLIENT");
        SQLRow rowAdresse = rowClient.getForeignRow("ID_ADRESSE");
        if (!clientRowNX.isForeignEmpty("ID_ADRESSE_F")) {
            rowAdresse = clientRowNX.getForeign("ID_ADRESSE_F");
        }
        SQLRow rowCompteClient = clientRowNX.getForeignRow("ID_COMPTE_PCE");
        String numero = rowCompteClient.getString("NUMERO");
        map.put("ClientNumeroCompte", numero);
        map.put("ClientType", rowClient.getString("FORME_JURIDIQUE"));
        map.put("ClientNom", rowClient.getString("NOM"));
        map.put("ClientAdresse", rowAdresse.getString("RUE"));
        map.put("ClientCodePostal", rowAdresse.getString("CODE_POSTAL"));
        String villeCli = rowAdresse.getString("VILLE");
        Object cedexCli = rowAdresse.getObject("CEDEX");
        boolean hasCedexCli = rowAdresse.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        map.put("ClientVille", villeCli);
        Date d = (Date)this.rowRelance.getObject("DATE");
        map.put("RelanceDate", this.dateFormat.format(d));
        map.put("RelanceNumero", this.rowRelance.getString("NUMERO"));
        SQLRow rowFacture = this.rowRelance.getForeignRow("ID_SAISIE_VENTE_FACTURE");
        Long lTotal = (Long)rowFacture.getObject("T_TTC");
        Long lRestant = (Long)this.rowRelance.getObject("MONTANT");
        Long lVerse = new Long(lTotal - lRestant);
        map.put("FactureNumero", rowFacture.getString("NUMERO"));
        map.put("FactureTotal", GestionDevise.currencyToString(lTotal, true));
        map.put("FactureRestant", GestionDevise.currencyToString(lRestant, true));
        map.put("FactureVerse", GestionDevise.currencyToString(lVerse, true));
        map.put("FactureDate", this.dateFormat2.format((Date)rowFacture.getObject("DATE")));
        Date dFacture = (Date)rowFacture.getObject("DATE");
        SQLRow modeRegRow = rowFacture.getForeignRow("ID_MODE_REGLEMENT");
        Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), dFacture);
        map.put("FactureDateEcheance", this.dateFormat2.format(dateEch));
        SQLSelect sel = new SQLSelect();
        sel.addSelect(this.rowRelance.getTable().getKey());
        sel.addSelect(this.rowRelance.getTable().getField("DATE"));
        sel.setWhere(new Where((FieldRef)this.rowRelance.getTable().getField("ID_SAISIE_VENTE_FACTURE"), "=", this.rowRelance.getInt("ID_SAISIE_VENTE_FACTURE")));
        sel.addFieldOrder(this.rowRelance.getTable().getField("DATE"));
        List<SQLRow> listResult = SQLRowListRSH.execute(sel);
        String oldDateRelance = "";
        if (listResult != null && listResult.size() > 0) {
            SQLRow rowOldRelance = listResult.get(0);
            Date dOldRelance = (Date)rowOldRelance.getObject("DATE");
            map.put("DatePremiereRelance", this.dateFormat2.format(dOldRelance));
            for (SQLRow rowOldR : listResult) {
                oldDateRelance = String.valueOf(oldDateRelance) + this.dateFormat2.format((Date)rowOldR.getObject("DATE")) + ", ";
            }
        } else {
            map.put("DatePremiereRelance", "");
        }
        map.put("DateAncienneRelance", oldDateRelance);
        return map;
    }

    public RelanceSheet(SQLRow row) {
        this.rowRelance = row;
        Date d = (Date)this.rowRelance.getObject("DATE");
        String year = this.yearFormat.format(d);
        SQLRow rowLettre = this.rowRelance.getForeignRow("ID_TYPE_LETTRE_RELANCE");
        String string = rowLettre.getString("MODELE");
        System.err.println(String.valueOf(this.locationTemplate) + "/" + string);
        this.init(year, string, "RelancePrinter");
    }

    @Override
    protected boolean savePDF() {
        return true;
    }

    @Override
    protected String getName() {
        return "Relance_" + this.rowRelance.getString("NUMERO");
    }
}

