/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.supplychain.stock.element.EtatStock;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public class EtatStockSnapshotCreator {
    private final Date d;
    private final DBRoot root;
    private final SQLRowAccessor depot;

    public EtatStockSnapshotCreator(SQLRowAccessor depot, Date d, DBRoot root) {
        this.d = d;
        this.depot = depot;
        this.root = root;
    }

    public void create() {
        Integer idMvtStockDeb;
        Date dateDeb;
        SQLTable tableEtatStock = this.root.getTable("ETAT_STOCK");
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(tableEtatStock);
        Where wEtat = new Where((FieldRef)tableEtatStock.getField("INVENTAIRE"), "=", (Object)Boolean.TRUE);
        wEtat = wEtat.and(new Where((FieldRef)tableEtatStock.getField("ID_DEPOT_STOCK"), "=", this.depot.getID()));
        sel.setWhere(wEtat);
        List<SQLRow> rowsEtatStock = SQLRowListRSH.execute(sel);
        HashMap<Integer, Integer> mapEtatStock = new HashMap<Integer, Integer>();
        for (SQLRow sqlRow : rowsEtatStock) {
            SQLTable tableMvtStock = this.root.getTable("MOUVEMENT_STOCK");
            SQLTable tableStock = this.root.getTable("STOCK");
            SQLSelect selMvt = new SQLSelect();
            selMvt.addSelect(tableMvtStock.getKey(), "MIN");
            Where wMvt = new Where((FieldRef)tableMvtStock.getField("OUVERTURE"), "=", (Object)Boolean.TRUE);
            wMvt = wMvt.and(new Where((FieldRef)tableMvtStock.getField("ID_ETAT_STOCK"), "=", sqlRow.getID()));
            wMvt = wMvt.and(new Where((FieldRef)tableMvtStock.getField("ID_STOCK"), "=", tableStock.getKey()));
            wMvt = wMvt.and(new Where((FieldRef)tableStock.getField("ID_DEPOT_STOCK"), "=", this.depot.getID()));
            selMvt.setWhere(wMvt);
            Integer idMvt = (Integer)tableMvtStock.getDBSystemRoot().getDataSource().executeScalar(selMvt.asString());
            if (idMvt == null) continue;
            mapEtatStock.put(sqlRow.getID(), idMvt);
        }
        HashMap<Integer, EtatStock> mapStockSnap = new HashMap<Integer, EtatStock>();
        final SQLTable tableMvtStock = this.root.getTable("MOUVEMENT_STOCK");
        SQLRowValues vals = new SQLRowValues(tableMvtStock);
        vals.put("QTE", null);
        if (tableMvtStock.contains("PRICE")) {
            vals.put("PRICE", null);
        }
        vals.put("ID_ARTICLE", null);
        vals.putRowValues("ID_STOCK").putNulls("QTE_REEL").putRowValues("ID_DEPOT_STOCK").putNulls("ID", "NOM", "CODE");
        SQLSelect selEtatD = new SQLSelect();
        selEtatD.addSelectStar(tableEtatStock);
        Where wEtatD = new Where((FieldRef)tableEtatStock.getField("INVENTAIRE"), "=", (Object)Boolean.TRUE);
        wEtatD = wEtatD.and(new Where((FieldRef)tableEtatStock.getField("ID_DEPOT_STOCK"), "=", this.depot.getID()));
        selEtatD.setWhere(wEtatD);
        List<SQLRow> rowsEtatStockD = SQLRowListRSH.execute(selEtatD);
        SQLRowAccessor rowEtatStockDeb = null;
        for (SQLRow sqlRow : rowsEtatStockD) {
            if (!sqlRow.getDate("DATE").getTime().before(this.d) || rowEtatStockDeb != null && !rowEtatStockDeb.getDate("DATE").before(sqlRow.getDate("DATE"))) continue;
            rowEtatStockDeb = sqlRow;
        }
        if (rowEtatStockDeb != null) {
            dateDeb = rowEtatStockDeb.getDate("DATE").getTime();
            idMvtStockDeb = (Integer)mapEtatStock.get(((SQLRow)rowEtatStockDeb).getID());
        } else {
            dateDeb = null;
            idMvtStockDeb = null;
        }
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(vals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                Where w = new Where((FieldRef)tableMvtStock.getField("DATE"), "<=", (Object)EtatStockSnapshotCreator.this.d);
                if (dateDeb != null) {
                    w = w.and(new Where((FieldRef)tableMvtStock.getField("DATE"), ">=", (Object)dateDeb));
                    w = w.and(new Where((FieldRef)tableMvtStock.getKey(), ">=", (Object)idMvtStockDeb));
                    w = w.and(new Where((FieldRef)tableMvtStock.getField("CLOTURE"), "!=", (Object)Boolean.TRUE));
                }
                w = w.and(new Where((FieldRef)tableMvtStock.getField("REEL"), "=", (Object)Boolean.TRUE));
                w = w.and(new Where(sel.getJoin(tableMvtStock.getField("ID_STOCK")).getJoinedTable().getField("ID_DEPOT_STOCK"), "=", EtatStockSnapshotCreator.this.depot.getID()));
                sel.setWhere(w);
                return sel;
            }
        });
        List<SQLRowValues> list = fetcher.fetch();
        BigDecimal totalHT = BigDecimal.ZERO;
        int i = 0;
        while (i < list.size()) {
            SQLRowValues rowVF = list.get(i);
            if (!rowVF.isForeignEmpty("ID_ARTICLE") && rowVF.getForeignID("ID_ARTICLE") > rowVF.getForeign("ID_ARTICLE").getTable().getUndefinedID()) {
                int foreignIDArt = rowVF.getForeignID("ID_ARTICLE");
                if (!mapStockSnap.containsKey(foreignIDArt)) {
                    mapStockSnap.put(foreignIDArt, new EtatStock(rowVF.getForeign("ID_ARTICLE")));
                }
                EtatStock et = (EtatStock)mapStockSnap.get(foreignIDArt);
                et.setQte(et.getQte().add(new BigDecimal(rowVF.getFloat("QTE"))));
                BigDecimal bigDecimal = BigDecimal.ZERO;
                if (tableMvtStock.contains("PRICE")) {
                    bigDecimal = rowVF.getBigDecimal("PRICE");
                }
                et.setPa(bigDecimal);
                totalHT = totalHT.add(bigDecimal.multiply(new BigDecimal(rowVF.getFloat("QTE"), DecimalUtils.HIGH_PRECISION)));
            }
            ++i;
        }
        final SQLTable tableStock = tableMvtStock.getTable("STOCK");
        SQLRowValues valsStock = new SQLRowValues(tableStock);
        valsStock.putRowValues("ID_ARTICLE").putNulls("CODE", "NOM", "OBSOLETE");
        valsStock.putNulls("QTE_REEL").putRowValues("ID_DEPOT_STOCK").putNulls("ID", "NOM", "CODE");
        SQLRowValuesListFetcher fetcherStock = SQLRowValuesListFetcher.create(valsStock);
        fetcherStock.addSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)tableStock.getField("ID_DEPOT_STOCK"), "=", EtatStockSnapshotCreator.this.depot.getID());
                w = w.and(new Where(input.getAlias(tableStock.getForeignTable("ID_ARTICLE")).getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
                input.setWhere(w);
                System.err.println(input.asString());
                return input;
            }
        }, 0);
        List<SQLRowValues> resultAllStock = fetcherStock.fetch();
        for (SQLRowValues sqlRowValues : resultAllStock) {
            int foreignIDArt = sqlRowValues.getForeignID("ID_ARTICLE");
            if (mapStockSnap.containsKey(foreignIDArt)) continue;
            mapStockSnap.put(foreignIDArt, new EtatStock(sqlRowValues.getForeign("ID_ARTICLE")));
        }
        SQLRowValues rowVals = new SQLRowValues(tableEtatStock);
        rowVals.put("DATE", this.d);
        rowVals.put("MONTANT_HA", totalHT);
        rowVals.put("ID_DEPOT_STOCK", this.depot.getID());
        for (EtatStock etatItem : mapStockSnap.values()) {
            SQLRowValues rowValsItem = new SQLRowValues(tableEtatStock.getTable("ETAT_STOCK_ELEMENT"));
            rowValsItem.put("ID_ETAT_STOCK", (Object)rowVals);
            rowValsItem.put("PA", etatItem.getPa());
            rowValsItem.put("PV", etatItem.getPv());
            rowValsItem.put("QTE", etatItem.getQte());
            rowValsItem.put("T_PA", etatItem.getTotalPA());
            rowValsItem.put("T_PV", etatItem.getTotalPV());
            rowValsItem.put("CODE", etatItem.getArticle().getString("CODE"));
            rowValsItem.put("NOM", etatItem.getArticle().getString("NOM"));
            rowValsItem.put("ID_ARTICLE", etatItem.getArticle().getID());
        }
        try {
            rowVals.commit();
        }
        catch (SQLException e) {
            ExceptionHandler.handle("Erreur lors de la cr\u00e9ation de l'\u00e9tat", e);
        }
    }
}

