/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateIListFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesMouvementsStockAction
extends CreateIListFrameAbstractAction<MouvementStockSQLElement> {
    private final SQLRowAccessor rowArtFilter;

    public ListeDesMouvementsStockAction(ComptaPropsConfiguration conf) {
        this(conf, (SQLRowAccessor)null);
    }

    public ListeDesMouvementsStockAction(ComptaPropsConfiguration conf, SQLRowAccessor rowArticleFilter) {
        super(conf, MouvementStockSQLElement.class);
        this.rowArtFilter = rowArticleFilter;
    }

    @Override
    protected SQLTableModelSource createTableSource() {
        SQLTableModelSourceOnline source = ((MouvementStockSQLElement)this.getElem()).createTableSource();
        if (this.rowArtFilter != null && !this.rowArtFilter.isUndefined()) {
            source.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(new Where((FieldRef)input.getTable("MOUVEMENT_STOCK").getField("ID_ARTICLE"), "=", ListeDesMouvementsStockAction.this.rowArtFilter.getID()));
                    return input;
                }
            });
        }
        return source;
    }

    @Override
    protected void initFrame(final IListFrame frame) {
        super.initFrame(frame);
        if (this.rowArtFilter != null && !this.rowArtFilter.isUndefined()) {
            frame.setTextTitle("Mouvements de stocks, article " + this.rowArtFilter.getString("CODE") + " " + this.rowArtFilter.getString("NOM"));
        }
        Object element = this.getElem();
        JTable table = frame.getPanel().getListe().getJTable();
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    menuDroit.add(new AbstractAction("Voir la source"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MouvementStockSQLElement.showSource(frame.getPanel().getListe().getSelectedId());
                        }
                    });
                    menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }
        });
        IListFilterDatePanel datePanel = new IListFilterDatePanel(frame.getPanel().getListe(), ((SQLElement)element).getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.0;
        ++c.gridy;
        ++c.gridy;
        c.anchor = 10;
        datePanel.setFilterOnDefault();
        frame.getPanel().add((Component)datePanel, c);
    }
}

