/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.AlternateTableCellRenderer;

public class BonLivraisionRenderer
extends DeviseNiceTableCellRenderer {
    private static HashSet<Integer> setFacture = new HashSet();
    private static BonLivraisionRenderer instance;

    static {
        final SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLSelect select = new SQLSelect(Configuration.getInstance().getBase());
        select.addSelect(eltFact.getTable().getField("IDSOURCE"));
        Where w = new Where((FieldRef)eltFact.getTable().getField("SOURCE"), "=", (Object)"BON_DE_LIVRAISON");
        select.setWhere(w);
        List l = Configuration.getInstance().getBase().getDataSource().executeCol(select.asString());
        for (Integer integer : l) {
            setFacture.add(integer);
        }
        eltFact.getTable().addTableModifiedListener(new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                SQLRow row;
                if (evt.getTable().getName().equalsIgnoreCase(eltFact.getTable().getName()) && (row = evt.getRow()).getString("SOURCE").equalsIgnoreCase("BON_DE_LIVRAISON")) {
                    if (evt.getMode() == SQLTableEvent.Mode.ROW_ADDED) {
                        setFacture.add(row.getInt("IDSOURCE"));
                        System.err.println("Ajout bon de livraison");
                    } else if (evt.getMode() == SQLTableEvent.Mode.ROW_UPDATED && row.isArchived()) {
                        setFacture.remove(row.getInt("IDSOURCE"));
                        System.err.println("suppression bon de livraison");
                    }
                }
            }
        });
        instance = null;
    }

    public static synchronized BonLivraisionRenderer getInstance() {
        if (instance == null) {
            instance = new BonLivraisionRenderer();
        }
        return instance;
    }

    private BonLivraisionRenderer() {
        AlternateTableCellRenderer.setBGColorMap(this, Collections.singletonMap(couleurFacture, couleurFactureMore));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int rowID = ITableModel.getLine(table.getModel(), row).getID();
        if (setFacture.contains(rowID)) {
            if (isSelected) {
                comp.setBackground(couleurFactureDark);
            } else {
                comp.setBackground(couleurFacture);
            }
        }
        return comp;
    }

    public JPanel getLegendePanel() {
        JPanel panelLegende = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabel labelFacture = new JLabel("Bons de livraison transf\u00e9r\u00e9s en facture");
        JPanel panel = new JPanel();
        panel.add(labelFacture);
        panel.setBackground(couleurFacture);
        panelLegende.add((Component)panel, c);
        return panelLegende;
    }
}

