/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.sales.invoice.report.ReportingVenteXmlSheet;
import org.openconcerto.erp.core.sales.invoice.ui.SelectCommerciauxModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;

public class GenReportingVentePanel
extends JPanel
implements ActionListener {
    private final JButton buttonGen = new JButton("Cr\u00e9er");
    private final JDate du;
    private final JDate au;
    JProgressBar bar = new JProgressBar();
    private JTable table;
    private final boolean commande;

    public GenReportingVentePanel(boolean commande) {
        super(new GridBagLayout());
        this.commande = commande;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 10;
        this.add((Component)new JLabelBold("Reporting des " + (commande ? "commandes" : "factures")), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.anchor = 17;
        this.add((Component)new JLabel("Du"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.du = new JDate(true);
        this.add((Component)this.du, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("au"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.au = new JDate(true);
        this.add((Component)this.au, c);
        this.table = new JTable(new SelectCommerciauxModel());
        JScrollPane scroll = new JScrollPane(this.table);
        Dimension d = this.table.getPreferredSize().height > 200 ? new Dimension(scroll.getPreferredSize().width, 200) : new Dimension(scroll.getPreferredSize().width, this.table.getPreferredSize().height + 30);
        scroll.setPreferredSize(d);
        ++c.gridx;
        c.gridwidth = 0;
        this.add((Component)scroll, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.bar, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        JPanel panelButton = new JPanel();
        panelButton.add(this.buttonGen);
        JButton buttonClose = new JButton("Fermer");
        panelButton.add(buttonClose);
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 14;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.add((Component)panelButton, c);
        this.buttonGen.addActionListener(this);
        buttonClose.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonGen) {
            final List<Integer> idS = ((SelectCommerciauxModel)this.table.getModel()).getSelectedIds(this.table.getSelectedRows());
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReportingVenteXmlSheet sheet = new ReportingVenteXmlSheet(idS, GenReportingVentePanel.this.du.getDate(), GenReportingVentePanel.this.au.getDate(), GenReportingVentePanel.this.bar, GenReportingVentePanel.this.commande);
                        sheet.createDocumentAsynchronous().get();
                        sheet.showPrintAndExport(true, false, false, false, false, Collections.emptyList());
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Erreur de traitement", e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JFrame)SwingUtilities.getRoot(GenReportingVentePanel.this)).dispose();
                        }
                    });
                }
            });
            thread.start();
        } else {
            ((JFrame)SwingUtilities.getRoot(this)).dispose();
        }
    }
}

