/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.Calendar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.table.TableCellRendererDecorator;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class EcritureCheckedRenderer
extends TableCellRendererDecorator {
    private static final Color couleurEcritureNonValide = new Color(253, 243, 204);
    private static final Color couleurEcritureToDay = new Color(225, 254, 207);
    private static final Color couleurEcritureLettree = new Color(255, 232, 245);
    private final String fieldName;

    public EcritureCheckedRenderer(TableCellRenderer r, String fieldName) {
        super(r);
        this.fieldName = fieldName;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component res = this.getRenderer(table, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setBackgroundColor(res, table, isSelected);
        if (!isSelected) {
            String string;
            SQLRowValues ecritureRow = ITableModel.getLine(table.getModel(), row).getRow();
            if (!ecritureRow.getBoolean("VALIDE").booleanValue()) {
                Calendar dateEcr = ecritureRow.getDate("DATE");
                Calendar dateToDay = Calendar.getInstance();
                if (dateEcr.get(6) == dateToDay.get(6) && dateEcr.get(1) == dateToDay.get(1)) {
                    res.setBackground(couleurEcritureToDay);
                } else {
                    res.setBackground(couleurEcritureNonValide);
                }
            }
            if (this.fieldName != null && (string = ecritureRow.getString(this.fieldName)) != null && string.trim().length() > 0) {
                res.setBackground(couleurEcritureLettree);
            }
        }
        return res;
    }

    public static Color getCouleurEcritureNonValide() {
        return couleurEcritureNonValide;
    }

    public static Color getCouleurEcritureToDay() {
        return couleurEcritureToDay;
    }

    public static Color getCouleurEcriturePointee() {
        return couleurEcritureLettree;
    }

    public static final class EcritureUtils<R extends EcritureCheckedRenderer>
    extends TableCellRendererDecorator.TableCellRendererDecoratorUtils<R> {
        protected EcritureUtils(Class<R> clazz) {
            super(clazz);
        }

        @Override
        protected boolean replaces(TableCellRenderer r) {
            return EcritureCheckedRenderer.class.isAssignableFrom(r.getClass());
        }
    }
}

