/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.CollectionUtils;

public class CompteRowValuesRenderer
extends DefaultTableCellRenderer {
    private static final Color red = new Color(255, 31, 52);
    private static final Color redLightGrey = new Color(240, 65, 85);
    private static final Color redGrey = new Color(224, 115, 137);
    private static final Color orange = new Color(255, 134, 62);
    private static final Color orangeGrey = new Color(255, 160, 110);
    private static final Color orangeLight = new Color(255, 201, 168);
    private boolean createAutoActive = false;
    private Map<String, Boolean> cache = new HashMap<String, Boolean>();

    static {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                SQLTable table = Configuration.getInstance().getDirectory().getElement("COMPTE_PCE").getTable();
                SQLBackgroundTableCache.getInstance().add(table, 3600);
                SQLBackgroundTableCache.getInstance().getCacheForTable(table);
            }
        });
        th.setDaemon(true);
        th.setPriority(1);
        th.start();
    }

    public CompteRowValuesRenderer() {
        AlternateTableCellRenderer.setBGColorMap(this, CollectionUtils.createMap(orange, orangeGrey, red, redLightGrey));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setColors(comp, table, isSelected);
        if (column == 0 && value != null && value instanceof String) {
            boolean exist;
            String account = (String)value;
            if (this.cache.get(account) == null) {
                exist = ComptePCESQLElement.isExist(account);
                this.cache.put(account, exist);
            } else {
                exist = this.cache.get(account);
            }
            if (!exist) {
                if (!isSelected) {
                    if (this.createAutoActive) {
                        comp.setBackground(orange);
                    } else {
                        comp.setBackground(red);
                    }
                } else if (this.createAutoActive) {
                    comp.setBackground(orangeLight);
                } else {
                    comp.setBackground(redGrey);
                }
                comp.setForeground(Color.WHITE);
            }
        }
        return comp;
    }

    public void setCreateActive(boolean b) {
        this.createAutoActive = b;
    }
}

