/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class BalanceAgeeListeSheetXML
extends AbstractListeSheetXml {
    private Date deb;
    private Date fin;
    public static String TEMPLATE_ID = "Balance ag\u00e9e";
    private boolean excludeCloture;
    Date d;

    public BalanceAgeeListeSheetXML(Date deb, Date fin, boolean excludeClotureEcr) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.deb = deb;
        this.fin = fin;
        this.excludeCloture = excludeClotureEcr;
    }

    @Override
    public String getDefaultTemplateId() {
        return "BalanceAgee";
    }

    @Override
    public String getName() {
        if (this.d == null) {
            this.d = new Date();
        }
        return "BalanceAgee" + this.d.getTime();
    }

    @Override
    protected String getStoragePathP() {
        return "Balance";
    }

    @Override
    protected void createListeValues() {
        final SQLElement ecr = Configuration.getInstance().getDirectory().getElement("ECRITURE");
        SQLElement fact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLRowValues rowValsEcr = new SQLRowValues(ecr.getTable());
        rowValsEcr.put("COMPTE_NUMERO", null);
        rowValsEcr.put("COMPTE_NOM", null);
        rowValsEcr.put("DATE_LETTRAGE", null);
        rowValsEcr.put("NOM", null);
        rowValsEcr.put("DEBIT", null);
        rowValsEcr.put("DATE", null);
        rowValsEcr.put("CREDIT", null);
        SQLRowValues rowValsMvt = new SQLRowValues(ecr.getTable().getForeignTable("ID_MOUVEMENT"));
        rowValsMvt.put("IDSOURCE", null);
        rowValsMvt.put("SOURCE", null);
        rowValsEcr.put("ID_MOUVEMENT", (Object)rowValsMvt);
        SQLSelect sel = new SQLSelect();
        sel.addSelect(ecr.getTable().getField("LETTRAGE"));
        Where w = new Where((FieldRef)ecr.getTable().getField("LETTRAGE"), "IS NOT", (Object)null);
        w = w.and(new Where((FieldRef)ecr.getTable().getField("LETTRAGE"), "!=", (Object)""));
        if (this.fin == null) {
            this.fin = new Date();
        }
        w = w.and(new Where((FieldRef)ecr.getTable().getField("DATE"), "<=", (Object)this.fin));
        sel.setWhere(w);
        List lettrageList = Configuration.getInstance().getBase().getDataSource().executeCol(sel.asString());
        SQLSelect sel2 = new SQLSelect();
        sel2.addSelect(ecr.getTable().getField("LETTRAGE"));
        Where w2 = new Where((FieldRef)ecr.getTable().getField("LETTRAGE"), "IS NOT", (Object)null);
        w2 = w2.and(new Where((FieldRef)ecr.getTable().getField("LETTRAGE"), "!=", (Object)""));
        if (this.deb != null) {
            w2 = w2.and(new Where((FieldRef)ecr.getTable().getField("DATE"), ">=", (Object)this.deb));
        }
        w2 = w2.and(new Where((FieldRef)ecr.getTable().getField("DATE"), "<=", (Object)this.fin));
        sel2.addGroupBy(ecr.getTable().getField("LETTRAGE"));
        sel2.setHaving(Where.createRaw("SUM(\"DEBIT\") != SUM(\"CREDIT\")", Arrays.asList(ecr.getTable().getField("DEBIT"), ecr.getTable().getField("CREDIT"))));
        sel2.setWhere(w2);
        System.err.println(sel2.asString());
        lettrageList.addAll(Configuration.getInstance().getBase().getDataSource().executeCol(sel2.asString()));
        final HashSet lettrageToExclude = new HashSet();
        lettrageToExclude.addAll(lettrageList);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(rowValsEcr);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLTable tableEcriture = ecr.getTable();
                Where w = new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%");
                if (BalanceAgeeListeSheetXML.this.deb != null) {
                    w = w.and(new Where((FieldRef)tableEcriture.getField("DATE"), ">=", (Object)BalanceAgeeListeSheetXML.this.deb));
                }
                w = w.and(new Where((FieldRef)tableEcriture.getField("DATE"), "<=", (Object)BalanceAgeeListeSheetXML.this.fin));
                if (BalanceAgeeListeSheetXML.this.excludeCloture) {
                    w = w.and(new Where((FieldRef)tableEcriture.getField("NOM"), "NOT LIKE", (Object)"Fermeture du compte %"));
                    w = w.and(new Where((FieldRef)ecr.getTable().getField("NOM"), "!=", (Object)"A nouveaux"));
                }
                Where wLettrage = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "IS", (Object)null);
                wLettrage = wLettrage.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)""));
                String aliasEcr = input.getAlias(tableEcriture.getField("LETTRAGE")).getAlias();
                wLettrage = wLettrage.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), true, lettrageToExclude));
                input.setWhere(w.and(wLettrage));
                input.addFieldOrder(tableEcriture.getField("COMPTE_NUMERO"));
                System.err.println(input.asString());
                return input;
            }
        });
        ArrayList<Map> valuesTab = new ArrayList<Map>();
        List<SQLRowValues> l = fetcher.fetch();
        LinkedHashMap<String, Map<String, String>> vals = new LinkedHashMap<String, Map<String, String>>();
        long total0 = 0L;
        long total30 = 0L;
        long total60 = 0L;
        long total90 = 0L;
        long totalPlus = 0L;
        long totalFull = 0L;
        long totalEchue = 0L;
        long timeInMillis = this.fin.getTime();
        for (SQLRowValues sqlRow : l) {
            Map<String, String> m;
            long date = sqlRow.getDate("DATE").getTimeInMillis();
            SQLRowAccessor rowMvt = sqlRow.getForeign("ID_MOUVEMENT");
            if (rowMvt.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                SQLRow rowFact = fact.getTable().getRow(rowMvt.getInt("IDSOURCE"));
                date = ModeDeReglementSQLElement.calculDate(rowFact.getForeignRow("ID_MODE_REGLEMENT"), rowFact.getDate("DATE").getTime()).getTime();
            }
            long time = timeInMillis - date;
            long day = time / 86400000L;
            String num = sqlRow.getString("COMPTE_NUMERO");
            if (vals.get(num) == null) {
                m = new HashMap();
                vals.put(num, m);
            } else {
                m = (Map)vals.get(num);
            }
            long value = sqlRow.getLong("DEBIT") - sqlRow.getLong("CREDIT");
            totalFull += value;
            String key = "+90";
            if (day < 0L) {
                key = "0";
                total0 += value;
            } else {
                totalEchue += value;
                if (day <= 30L) {
                    key = "30";
                    total30 += value;
                } else if (day <= 60L) {
                    key = "60";
                    total60 += value;
                } else if (day <= 90L) {
                    key = "90";
                    total90 += value;
                } else {
                    totalPlus += value;
                }
            }
            m.put("NUMERO", num);
            m.put("NOM", sqlRow.getString("COMPTE_NOM"));
            if (m.get(key) == null) {
                m.put(key, (String)((Object)Long.valueOf(value)));
            } else {
                long cred = (Long)m.get(key);
                m.put(key, (String)((Object)Long.valueOf(cred + value)));
            }
            long total = 0L;
            if (m.get("TOTAL") != null) {
                total = (Long)m.get("TOTAL");
            }
            m.put("TOTAL", (String)((Object)Long.valueOf(total + value)));
        }
        System.err.println("INTERMED BALANCE");
        for (String k : vals.keySet()) {
            Map e = (Map)vals.get(k);
            Long l0 = (Long)e.get("0");
            Long l1 = (Long)e.get("30");
            Long l2 = (Long)e.get("60");
            Long l3 = (Long)e.get("90");
            Long l4 = (Long)e.get("+90");
            Long l5 = (Long)e.get("TOTAL");
            if (!(l0 != null && l0 != 0L || l1 != null && l1 != 0L || l2 != null && l2 != 0L || l3 != null && l3 != 0L) && (l4 == null || l4 == 0L)) continue;
            if (l0 != null && l0 != 0L) {
                e.put("0", (double)l0.longValue() / 100.0);
            }
            if (l1 != null && l1 != 0L) {
                e.put("30", (double)l1.longValue() / 100.0);
            }
            if (l2 != null && l2 != 0L) {
                e.put("60", (double)l2.longValue() / 100.0);
            }
            if (l3 != null && l3 != 0L) {
                e.put("90", (double)l3.longValue() / 100.0);
            }
            if (l4 != null && l4 != 0L) {
                e.put("+90", (double)l4.longValue() / 100.0);
            }
            if (l5 != null && l5 != 0L) {
                e.put("TOTAL", (double)l5.longValue() / 100.0);
            }
            valuesTab.add(e);
        }
        HashMap<String, Object> totalMap = new HashMap<String, Object>();
        totalMap.put("NOM", "TOTAL");
        totalMap.put("0", (double)total0 / 100.0);
        totalMap.put("30", (double)total30 / 100.0);
        totalMap.put("60", (double)total60 / 100.0);
        totalMap.put("90", (double)total90 / 100.0);
        totalMap.put("+90", (double)totalPlus / 100.0);
        totalMap.put("TOTAL", (double)totalFull / 100.0);
        totalMap.put("TOTAL_ECHUE", (double)totalEchue / 100.0);
        valuesTab.add(totalMap);
        System.err.println("FIN BALANCE");
        this.listAllSheetValues.put(0, valuesTab);
    }
}

