/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class TotalCalculatorParameters {
    private List<? extends SQLRowAccessor> values;
    private List<? extends SQLRowAccessor> valuesEchantillon;
    private long remiseHT;
    private BigDecimal portHT;
    private SQLRowAccessor tvaPort;
    private Map<Integer, SQLRowAccessor> mapArticle = new HashMap<Integer, SQLRowAccessor>();

    public TotalCalculatorParameters(List<? extends SQLRowAccessor> values) {
        this.values = values;
        this.portHT = BigDecimal.ZERO;
    }

    public void setValuesEchantillon(List<? extends SQLRowAccessor> valuesEchantillon) {
        this.valuesEchantillon = valuesEchantillon;
    }

    public List<? extends SQLRowAccessor> getValuesEchantillon() {
        return this.valuesEchantillon;
    }

    public void setPortHT(BigDecimal portHT) {
        this.portHT = portHT;
    }

    public BigDecimal getPortHT() {
        return this.portHT;
    }

    public void setRemiseHT(long remiseHT) {
        this.remiseHT = remiseHT;
    }

    public long getRemiseHT() {
        return this.remiseHT;
    }

    public Map<Integer, SQLRowAccessor> getMapArticle() {
        return this.mapArticle;
    }

    public void setTvaPort(SQLRowAccessor tvaPort) {
        this.tvaPort = tvaPort;
    }

    public SQLRowAccessor getTvaPort() {
        return this.tvaPort;
    }

    public void fetchArticle() {
        final ArrayList<Integer> l = new ArrayList<Integer>(this.values.size());
        for (SQLRowAccessor sQLRowAccessor : this.values) {
            l.add(sQLRowAccessor.getID());
        }
        DBRoot dBRoot = ComptaPropsConfiguration.getInstanceCompta().getRootSociete();
        final SQLTable articleTable = dBRoot.getTable("ARTICLE");
        SQLTable compteTable = dBRoot.getTable("COMPTE_PCE");
        SQLTable familleArticleTable = dBRoot.getTable("FAMILLE_ARTICLE");
        SQLRowValues rowValsC1 = new SQLRowValues(compteTable);
        rowValsC1.put("NUMERO", null);
        rowValsC1.put("ID", null);
        SQLRowValues rowValsC2 = new SQLRowValues(compteTable);
        rowValsC2.put("NUMERO", null);
        rowValsC2.put("ID", null);
        SQLRowValues rowValsF = new SQLRowValues(familleArticleTable);
        rowValsF.put("NOM", null);
        rowValsF.put("ID", null);
        rowValsF.put("ID_FAMILLE_ARTICLE_PERE", null);
        rowValsF.put("ID_COMPTE_PCE", (Object)rowValsC2);
        SQLRowValues rowVals = new SQLRowValues(articleTable);
        rowVals.put("ID", null);
        rowVals.put("ID_FAMILLE_ARTICLE", (Object)rowValsF);
        rowVals.put("ID_COMPTE_PCE", (Object)rowValsC1);
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
        fetch.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.andWhere(new Where(articleTable.getKey(), l));
                return input;
            }
        });
        List<SQLRowValues> rowValsList = fetch.fetch();
        for (SQLRowValues sqlRowValues : rowValsList) {
            this.mapArticle.put(sqlRowValues.getID(), sqlRowValues);
        }
    }
}

