/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.utils.StringUtils;

public class DeviseNumericCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected JTextField textField = new JTextField();
    protected int precision;
    protected final DecimalFormat decimalFormat = new DecimalFormat("0.00#######");

    public DeviseNumericCellEditor(SQLField field) {
        this(field.getType().getDecimalDigits());
    }

    public DeviseNumericCellEditor(final int precision) {
        DecimalFormatSymbols symbol = DecimalFormatSymbols.getInstance();
        symbol.setDecimalSeparator('.');
        this.decimalFormat.setDecimalFormatSymbols(symbol);
        this.textField.setBorder(new LineBorder(Color.black));
        this.textField.setHorizontalAlignment(4);
        this.precision = precision;
        this.textField.addKeyListener(new KeyAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char keychar = keyEvent.getKeyChar();
                if (keychar == '\b') {
                    return;
                }
                int pointPosition = DeviseNumericCellEditor.this.textField.getText().indexOf(46);
                if (Character.isDigit(keychar)) {
                    if (pointPosition <= -1) return;
                    if (DeviseNumericCellEditor.this.textField.getSelectedText() != null) return;
                    if (DeviseNumericCellEditor.this.textField.getCaretPosition() <= pointPosition) {
                        return;
                    }
                    if (DeviseNumericCellEditor.this.textField.getText().substring(pointPosition).length() <= precision) {
                        return;
                    }
                }
                if (keychar == '.' && DeviseNumericCellEditor.this.textField.getText().indexOf(46) < 0) {
                    return;
                }
                if (keychar == '-' && DeviseNumericCellEditor.this.textField.getText().indexOf(45) < 0 && DeviseNumericCellEditor.this.textField.getCaretPosition() == 0) {
                    return;
                }
                keyEvent.consume();
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DeviseNumericCellEditor.this.textField.setBorder(new LineBorder(Color.black));
                DeviseNumericCellEditor.this.textField.selectAll();
            }
        });
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.getCellEditorValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.textField.setBorder(new LineBorder(Color.RED));
            return false;
        }
        return super.stopCellEditing();
    }

    public void addKeyListener(KeyListener l) {
        this.textField.addKeyListener(l);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    @Override
    public Object getCellEditorValue() {
        return StringUtils.getBigDecimalFromUserText(this.textField.getText());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(value == null ? "0" : this.decimalFormat.format((BigDecimal)value));
        this.textField.selectAll();
        this.textField.grabFocus();
        return this.textField;
    }
}

