/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdom2.Document;
import org.jdom2.input.DOMBuilder;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.sql.view.list.TableAction;
import org.openconcerto.ui.AutoHideListener;
import org.openconcerto.ui.light.InformationLine;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.ui.light.RowSelectionSpec;
import org.openconcerto.ui.light.SimpleTextLine;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.convertor.ValueConvertor;

public abstract class SocieteSQLConfElement
extends SQLElement {
    public static final String ACTION_ID_ADD = "add";
    public static final String ACTION_ID_MODIFY = "modify";
    public static final String ACTION_ID_REMOVE = "remove";
    public static final TableCellRenderer CURRENCY_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res = super.getTableCellRendererComponent(table, GestionDevise.currencyToString((BigDecimal)value), isSelected, hasFocus, row, column);
            TableCellRendererUtils.setColors(res, table, isSelected);
            ((JLabel)res).setHorizontalAlignment(4);
            return res;
        }
    };
    private static final String ERP_CORE = ".erp.core.";
    private static final String ERP_ELEMENT = ".erp.element.";
    private static final SQLTable.VirtualFields FIELDS_TO_IGNORE = SQLTable.VirtualFields.PRIMARY_KEY.union(SQLTable.VirtualFields.ARCHIVE).union(SQLTable.VirtualFields.ORDER);

    public SocieteSQLConfElement(SQLTable table, String singular, String plural) {
        super(singular, plural, table);
    }

    public SocieteSQLConfElement(SQLTable table) {
        this(table, (String)null);
    }

    public SocieteSQLConfElement(SQLTable table, String code) {
        super(table, null, code);
    }

    public static final JPanel createAdditionalPanel() {
        return AutoHideListener.listen(new JPanel());
    }

    @Override
    protected String createCode() {
        String suffix = this.createCodeSuffix();
        if (suffix.indexOf(32) >= 0) {
            throw new IllegalStateException("Suffix contains space : '" + suffix + "'");
        }
        if (suffix.length() < 2) {
            throw new IllegalStateException("Suffix too short : '" + suffix + "'");
        }
        return String.valueOf(this.createCodeOfPackage()) + suffix;
    }

    protected String createCodeSuffix() {
        return this.createCodeSuffixFromTable();
    }

    protected final String createCodeSuffixFromTable() {
        return String.valueOf('.') + this.getTable().getName();
    }

    protected final String createCodeOfPackage() {
        return SocieteSQLConfElement.createCodeOfPackage(this.getLastNonAbstractClass());
    }

    private final Class<? extends SocieteSQLConfElement> getLastNonAbstractClass() {
        return SocieteSQLConfElement.getLastNonAbstractClass(this.getClass(), SocieteSQLConfElement.class);
    }

    /*
     * Unable to fully structure code
     */
    protected static final <T extends SQLElement> Class<? extends T> getLastNonAbstractClass(Class<? extends T> clazz, Class<T> superClass) {
        prev = null;
        cl = clazz;
        if (!SocieteSQLConfElement.$assertionsDisabled && !superClass.isAssignableFrom(cl)) {
            throw new AssertionError();
        }
        if (Modifier.isAbstract(cl.getModifiers())) {
            throw new IllegalArgumentException("Class is abstract : " + cl);
        }
        if (Modifier.isAbstract(superClass.getModifiers())) ** GOTO lbl11
        throw new IllegalArgumentException("Superclass isn't abstract : " + superClass);
lbl-1000:
        // 1 sources

        {
            prev = cl;
            cl = cl.getSuperclass();
lbl11:
            // 2 sources

            ** while (!Modifier.isAbstract((int)cl.getModifiers()))
        }
lbl12:
        // 1 sources

        return prev.asSubclass(superClass);
    }

    protected static String createCodeOfPackage(Class<? extends SQLElement> cl) {
        String canonicalName = cl.getPackage().getName();
        if (canonicalName.contains(ERP_CORE) && canonicalName.contains(".element")) {
            int i = canonicalName.indexOf(ERP_CORE) + ERP_CORE.length();
            int j = canonicalName.indexOf(".element");
            canonicalName = canonicalName.substring(i, j);
        } else if (canonicalName.contains(ERP_ELEMENT)) {
            canonicalName = canonicalName.substring(canonicalName.indexOf(ERP_ELEMENT) + ERP_ELEMENT.length());
        }
        return canonicalName;
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        for (SQLTableModelColumn col : res.getColumns()) {
            if (col.getValueClass() != Long.class && col.getValueClass() != BigInteger.class) continue;
            col.setConverter(new ValueConvertor<Number, BigDecimal>(){

                @Override
                public BigDecimal convert(Number o) {
                    if (o == null) {
                        System.err.println("ComptaSQLConfElement._initTableSource: Warning null Number conversion (" + this + ")");
                        return BigDecimal.ZERO;
                    }
                    return new BigDecimal(o.longValue()).movePointLeft(2);
                }

                @Override
                public Number unconvert(BigDecimal o) {
                    if (o == null) {
                        System.err.println("ComptaSQLConfElement._initTableSource: Warning null BigDecimal conversion (" + this + ")");
                        return 0;
                    }
                    return o.movePointRight(2);
                }
            }, BigDecimal.class);
            col.setRenderer(CURRENCY_RENDERER);
        }
    }

    protected Document getColumnsUserPerfs(Configuration configuration, int userId, String tableId, List<SQLTableModelColumn> sqlColumns) {
        Document columnsPrefs = null;
        try {
            DOMBuilder in = new DOMBuilder();
            org.w3c.dom.Document w3cDoc = configuration.getXMLConf(userId, tableId);
            if (w3cDoc != null) {
                columnsPrefs = in.build(w3cDoc);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to get ColumnPrefs for table " + tableId + " and for user " + userId + "\n" + ex.getMessage());
        }
        return columnsPrefs;
    }

    public LightUILine createSecondaryRowActionLine(RowSelectionSpec selection) {
        return null;
    }

    public final LightUIPanel createDataPanel(String sessionToken, List<SQLRowAccessor> selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        LightUIPanel dataPanel = new LightUIPanel(String.valueOf(this.getCode()) + ".data.panel");
        dataPanel.setVerticallyScrollable(true);
        dataPanel.setWeightX(1);
        dataPanel.setMarginLeft(4);
        this.fillDataPanel(sessionToken, selection, dataPanel);
        return dataPanel;
    }

    protected void fillDataPanel(String sessionToken, List<SQLRowAccessor> selection, LightUIPanel dataPanel) {
        SQLFieldTranslator translator = this.getDirectory().getTranslator();
        for (SQLRowAccessor listRow : selection) {
            int rowId = listRow.getID();
            LightUILine mainLine = new LightUILine();
            LightUIPanel mainLinePanel = new LightUIPanel(String.valueOf(dataPanel.getId()) + ".main.line." + rowId);
            mainLinePanel.setWeightX(1);
            mainLinePanel.addChild(new SimpleTextLine("Information sur l'\u00e9l\u00e9ment n\u00b0" + rowId, true, 1));
            LightUILine lineData = new LightUILine();
            LightUIPanel panel = new LightUIPanel(String.valueOf(this.getCode()) + ".data.panel." + rowId);
            panel.setWeightX(1);
            List<String> dataPanelFields = this.getDataPanelFields();
            for (String fieldName : dataPanelFields) {
                this.addFieldToPanel(fieldName, panel, listRow, translator);
            }
            lineData.addChild(panel);
            mainLinePanel.addChild(lineData);
            mainLine.addChild(mainLinePanel);
            dataPanel.addChild(mainLine);
        }
    }

    protected List<String> getDataPanelFields() {
        return this.getListFields();
    }

    public void addFieldToPanel(String fieldName, LightUIPanel dataPanel, SQLRowAccessor sqlRow, SQLFieldTranslator translator) {
        this.addFieldToPanel(fieldName, dataPanel, sqlRow, translator, false, "");
    }

    public void addFieldToPanel(String fieldName, LightUIPanel dataPanel, SQLRowAccessor sqlRow, SQLFieldTranslator translator, boolean addEmpty, String defaultValue) {
        SQLTable sqlTable = sqlRow.getTable();
        SQLField field = sqlTable.getField(fieldName);
        if (!sqlTable.getFields(FIELDS_TO_IGNORE).contains(field)) {
            String key = translator.getLabelFor(field);
            boolean error = false;
            if (key == null) {
                error = true;
                key = field.getFieldName();
            }
            String value = "";
            if (field.isKey()) {
                List<FieldPath> fieldsPath = this.getListExpander().expand(field);
                for (FieldPath fieldPath : fieldsPath) {
                    SQLRowValues foreignRow = sqlRow.asRowValues().followPath(fieldPath.getPath());
                    if (foreignRow == null) continue;
                    value = String.valueOf(value) + foreignRow.getString(fieldPath.getField().getName()) + " ";
                }
            } else {
                value = sqlRow.getString(fieldName);
            }
            boolean isDefault = false;
            if (value == null || value.isEmpty()) {
                isDefault = true;
                value = defaultValue;
            }
            if (!value.isEmpty() || addEmpty) {
                InformationLine line = new InformationLine(key, value);
                if (error) {
                    line.setLabelColor(Color.RED);
                }
                line.setItalicOnValue(isDefault);
                dataPanel.addChild(line);
            }
        }
    }

    public List<SQLRowValues> getRowValues(String fieldName, long id) {
        SQLTableModelSourceOnline tableSource = this.getTableSource(true);
        ListSQLRequest req = tableSource.getReq();
        req.setWhere(new Where((FieldRef)this.getTable().getField(fieldName), "=", (Object)id));
        return req.getValues();
    }

    @Override
    protected void _initComboRequest(ComboSQLRequest req) {
        super._initComboRequest(req);
        req.setSearchable(true);
    }

    public List<TableAction> getPrimaryRowActions() {
        ArrayList<TableAction> actions = new ArrayList<TableAction>(3);
        actions.add(new TableAction(this.getAddAction()));
        actions.add(new TableAction(this.getModifyAction()));
        actions.add(new TableAction(this.getRemoveAction()));
        return actions;
    }

    public List<TableAction> getSecondaryRowActions() {
        return new ArrayList<TableAction>(0);
    }

    public RowAction getAddAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, true, ACTION_ID_ADD){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return true;
            }
        };
    }

    public RowAction getModifyAction() {
        RowAction rowAction = new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, true, ACTION_ID_MODIFY){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1;
            }
        };
        return rowAction;
    }

    public RowAction getRemoveAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, true, ACTION_ID_REMOVE){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && !selection.isEmpty();
            }
        };
    }
}

