/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.ProductInfo;

public class BanqueSQLElement
extends ComptaSQLConfElement {
    public static final String TABLENAME = ProductInfo.getInstance().getName().equals("OpenConcerto") ? "BANQUE" : "BANQUE_POLE_PRODUIT";

    public BanqueSQLElement() {
        super(TABLENAME);
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> map = new ListMap<String, String>();
        map.add(null, "NOM");
        return map;
    }

    @Override
    protected void _initComboRequest(ComboSQLRequest req) {
        super._initComboRequest(req);
        req.addForeignToGraphToFetch("ID_JOURNAL", Arrays.asList("ID", "CODE", "NOM"));
        req.keepRows(ComboSQLRequest.KeepMode.GRAPH);
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("CODE");
        list.add("NOM");
        return list;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add("CODE");
        list.add("NOM");
        list.add("ID_JOURNAL");
        list.add("ID_COMPTE_PCE");
        return list;
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this, 2){

            @Override
            public void addViews() {
                this.addView("CODE");
                this.addView("NOM");
                this.addView("NUMERO_RUE");
                this.addView("VOIE");
                this.addView("RUE");
                this.addView("VILLE");
                this.addView("BIC");
                this.addView("IBAN");
                this.addView("AFFACTURAGE");
                this.addView("ID_JOURNAL");
                this.addView("ID_COMPTE_PCE");
                this.addView("INFOS");
            }
        };
    }

    @Override
    protected String createCode() {
        return "bank";
    }
}

