/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.Multigraph;
import org.jgrapht.graph.Pseudograph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.SimpleGraph;

public class RandomGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private static long seedUniquifier = 8682522807148012L;
    protected int numOfVertexes;
    protected int numOfEdges;
    protected Random randomizer;
    private long randomizerSeed;

    public RandomGraphGenerator(int aNumOfVertexes, int aNumOfEdges) {
        if (aNumOfVertexes < 0 || aNumOfEdges < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.numOfVertexes = aNumOfVertexes;
        this.numOfEdges = aNumOfEdges;
        this.randomizerSeed = RandomGraphGenerator.chooseRandomSeedOnce();
        this.randomizer = new Random(this.randomizerSeed);
    }

    private static synchronized long chooseRandomSeedOnce() {
        return ++seedUniquifier + System.nanoTime();
    }

    private void resetRandomSeed() {
        this.randomizer.setSeed(this.randomizerSeed);
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        this.resetRandomSeed();
        HashMap<Integer, V> orderToVertexMap = new HashMap<Integer, V>(this.numOfVertexes);
        int i = 0;
        while (i < this.numOfVertexes) {
            V currVertex = vertexFactory.createVertex();
            target.addVertex(currVertex);
            orderToVertexMap.put(i, currVertex);
            ++i;
        }
        EdgeTopologyFactory<V, E> edgesFactory = this.edgeTopologyFactoryChooser(target, this.numOfEdges);
        if (!edgesFactory.isNumberOfEdgesValid(target, this.numOfEdges)) {
            throw new IllegalArgumentException("numOfEdges is not valid for the graph type \n-> Invalid number Of Edges=" + this.numOfEdges + " for:" + " graph type=" + target.getClass() + " ,number Of Vertexes=" + this.numOfVertexes + "\n-> Advice: For the Max value , check the javadoc for" + " org.jgrapht.generate.RandomGraphGenerator.DefaultEdgeTopologyFactory");
        }
        edgesFactory.createEdges(target, orderToVertexMap, this.numOfEdges, this.randomizer);
    }

    private EdgeTopologyFactory<V, E> edgeTopologyFactoryChooser(Graph<V, E> target, int numOfEdges) {
        return new DefaultEdgeTopologyFactory();
    }

    public class DefaultEdgeTopologyFactory<VV, EE>
    implements EdgeTopologyFactory<VV, EE> {
        @Override
        public void createEdges(Graph<VV, EE> targetGraph, Map<Integer, VV> orderToVertexMap, int numberOfEdges, Random randomizer) {
            int iterationsCounter = 0;
            int edgesCounter = 0;
            while (edgesCounter < numberOfEdges) {
                VV startVertex = orderToVertexMap.get(randomizer.nextInt(RandomGraphGenerator.this.numOfVertexes));
                VV endVertex = orderToVertexMap.get(randomizer.nextInt(RandomGraphGenerator.this.numOfVertexes));
                try {
                    EE resultEdge = targetGraph.addEdge(startVertex, endVertex);
                    if (resultEdge != null) {
                        ++edgesCounter;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++iterationsCounter;
            }
        }

        @Override
        public boolean isNumberOfEdgesValid(Graph<VV, EE> targetGraph, int numberOfEdges) {
            boolean infinite = false;
            int maxAllowedEdges = this.getMaxEdgesForVertexNum(targetGraph);
            if (maxAllowedEdges == -1) {
                infinite = true;
            }
            boolean result = infinite ? true : numberOfEdges <= maxAllowedEdges;
            return result;
        }

        public int getMaxEdgesForVertexNum(Graph<VV, EE> targetGraph) {
            int maxAllowedEdges = 0;
            if (targetGraph instanceof SimpleGraph) {
                maxAllowedEdges = RandomGraphGenerator.this.numOfVertexes * (RandomGraphGenerator.this.numOfVertexes - 1) / 2;
            } else if (targetGraph instanceof SimpleDirectedGraph) {
                maxAllowedEdges = RandomGraphGenerator.this.numOfVertexes * (RandomGraphGenerator.this.numOfVertexes - 1);
            } else if (targetGraph instanceof DefaultDirectedGraph) {
                maxAllowedEdges = RandomGraphGenerator.this.numOfVertexes * RandomGraphGenerator.this.numOfVertexes;
            } else if (targetGraph instanceof Multigraph || targetGraph instanceof Pseudograph || targetGraph instanceof DirectedMultigraph) {
                maxAllowedEdges = -1;
            } else {
                throw new ClassCastException("cannot find the appropriate graph type");
            }
            return maxAllowedEdges;
        }
    }

    public static interface EdgeTopologyFactory<VV, EE> {
        public void createEdges(Graph<VV, EE> var1, Map<Integer, VV> var2, int var3, Random var4);

        public boolean isNumberOfEdgesValid(Graph<VV, EE> var1, int var2);
    }
}

