/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import jpos.util.DefaultProperties;
import jpos.util.TracerOutput;

public class Tracer {
    private boolean tracerOn = false;
    private TracerOutput onTracerOutput = new DefaultTracerOutput();
    private TracerOutput offTracerOutput = new TracerOutput(){

        public void println(String string) {
        }

        public void print(String string) {
        }
    };
    private static Tracer instance = null;

    private Tracer() {
    }

    public static Tracer getInstance() {
        if (instance == null) {
            instance = new Tracer();
            instance.init();
        }
        return instance;
    }

    public void println(String string) {
        this.getTracerOutput().println(string);
    }

    public void print(String string) {
        this.getTracerOutput().print(string);
    }

    public void setOn(boolean bl) {
        this.tracerOn = bl;
    }

    public boolean isOn() {
        return this.tracerOn;
    }

    private void init() {
        DefaultProperties defaultProperties = new DefaultProperties();
        defaultProperties.loadJposProperties();
        if (!defaultProperties.isPropertyDefined("jpos.util.tracing")) {
            this.setOn(false);
        } else {
            String string = defaultProperties.getPropertyString("jpos.util.tracing");
            if (string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE")) {
                this.setOn(true);
            }
        }
    }

    private TracerOutput getTracerOutput() {
        return this.isOn() ? this.onTracerOutput : this.offTracerOutput;
    }

    static class DefaultTracerOutput
    implements TracerOutput {
        public void println(String string) {
            System.err.println(string);
        }

        public void print(String string) {
            System.err.print(string);
        }
    }
}

