/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.ntp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.openconcerto.utils.ntp.Message;
import org.openconcerto.utils.ntp.Timestamp;

public class SNTPClient {
    protected final DatagramSocket socket = new DatagramSocket();
    private static final long SECS_1900_1970 = 2208988800L;

    public SNTPClient() throws SocketException {
        this.socket.setSoTimeout(10000);
    }

    public long getOffsetInMillis(String host, int port) throws IOException {
        InetAddress addr = InetAddress.getByName(host);
        Message smessage = new Message();
        smessage.setTransmitTimestamp(SNTPClient.toTimestamp(System.currentTimeMillis()));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        smessage.encodeMessage(output);
        byte[] data = output.toByteArray();
        output.close();
        DatagramPacket rpacket = new DatagramPacket(data, data.length, addr, port);
        this.socket.send(rpacket);
        DatagramPacket packet = new DatagramPacket(new byte[384], 384);
        this.socket.receive(packet);
        long destinationTime = System.currentTimeMillis();
        Message rmessage = Message.decodeMessage(new ByteArrayInputStream(packet.getData()));
        long originalTime = SNTPClient.fromTimestamp(rmessage.getOriginateTimestamp());
        long receiveTime = SNTPClient.fromTimestamp(rmessage.getReceiveTimestamp());
        long transmitTime = SNTPClient.fromTimestamp(rmessage.getTransmitTimestamp());
        return (receiveTime - originalTime + (transmitTime - destinationTime)) / 2L;
    }

    public void close() {
        this.socket.close();
    }

    private static Timestamp toTimestamp(long time) {
        double temp = (double)time / 1000.0;
        long integer = (long)Math.floor(temp);
        long fraction = (long)((temp - (double)integer) * 4.294967296E9);
        return new Timestamp(integer + 2208988800L, fraction);
    }

    private static final long fromTimestamp(Timestamp timestamp) {
        long time = (timestamp.getInteger() - 2208988800L) * 1000L;
        return time += timestamp.getFraction() * 1000L / 0x100000000L;
    }

    public static void main(String[] args) throws IOException {
        SNTPClient client = new SNTPClient();
        long offset = client.getOffsetInMillis("fr.pool.ntp.org", 123);
        client.close();
        System.out.println(offset);
    }
}

