/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import org.openconcerto.utils.cc.BiConsumerExn;

public final class ReentrantEventDispatcher<L, E, X extends Exception> {
    private final ThreadLocal<LinkedList<DispatchingState>> events = new ThreadLocal<LinkedList<DispatchingState>>(){

        @Override
        protected LinkedList<DispatchingState> initialValue() {
            return new LinkedList<DispatchingState>();
        }
    };
    private final BiConsumerExn<L, E, X> callback;

    public ReentrantEventDispatcher() {
        this(null);
    }

    public ReentrantEventDispatcher(BiConsumerExn<L, E, X> callback) {
        this.callback = callback;
    }

    public final void fire(Iterator<L> iter, E evt) throws X {
        this.fire(this.createDispatchingState(iter, evt));
    }

    public final void fire(Iterator<L> iter, BiConsumerExn<L, E, X> callback, E evt) throws X {
        this.fire(this.createDispatchingState(iter, callback, evt));
    }

    public final DispatchingState createDispatchingState(Iterator<L> iter, E evt) {
        return this.createDispatchingState(iter, this.callback, evt);
    }

    public final DispatchingState createDispatchingState(Iterator<L> iter, BiConsumerExn<L, E, X> callback, E evt) {
        return new DispatchingState(iter, callback, evt);
    }

    public final void fire(DispatchingState newTuple) throws X {
        DispatchingState currentTuple;
        LinkedList<DispatchingState> linkedList = this.events.get();
        linkedList.addLast(newTuple);
        while ((currentTuple = linkedList.peekFirst()) != null) {
            Iterator currentIter = currentTuple.getIterator();
            BiConsumerExn currentCallback = currentTuple.getCallback();
            Object currentEvt = currentTuple.getEvt();
            while (currentIter.hasNext()) {
                Object l = currentIter.next();
                currentCallback.accept(l, currentEvt);
            }
            linkedList.pollFirst();
        }
    }

    public final boolean remove(DispatchingState dispatchingState) {
        return this.events.get().remove(dispatchingState);
    }

    public final class DispatchingState {
        private final Iterator<L> iter;
        private final BiConsumerExn<L, E, X> callback;
        private final E evt;

        private DispatchingState(Iterator<L> iter, BiConsumerExn<L, E, X> callback, E evt) {
            this.iter = Objects.requireNonNull(iter, "Missing iterator");
            this.callback = Objects.requireNonNull(callback, "Missing callback");
            this.evt = evt;
        }

        private final Iterator<L> getIterator() {
            return this.iter;
        }

        private final BiConsumerExn<L, E, X> getCallback() {
            return this.callback;
        }

        public final E getEvt() {
            return this.evt;
        }
    }
}

