/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtils {
    public static final Properties createFromMap(Map<String, String> map) {
        return PropertiesUtils.loadFromMap(new Properties(), map);
    }

    public static final Properties loadFromMap(Properties res, Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            String key = e.getKey();
            if (key == null) {
                throw new NullPointerException("Null key : " + e);
            }
            String val = e.getValue();
            if (val == null) continue;
            res.setProperty(key, val);
        }
        return res;
    }

    public static final Map<String, String> toMap(Properties props) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            assert (value != null);
            res.put(key, value);
        }
        return res;
    }

    public static final Properties createFromFile(File f) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(f));){
            return PropertiesUtils.create(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final Properties createFromResource(Class<?> ctxt, String rsrc) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = ctxt.getResourceAsStream(rsrc);){
            return PropertiesUtils.create(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final Properties create(InputStream stream) throws IOException {
        if (stream != null) {
            Properties res = new Properties();
            res.load(stream);
            return res;
        }
        return null;
    }

    public static final void load(Properties props, Properties toLoad) {
        for (String key : toLoad.stringPropertyNames()) {
            String value = toLoad.getProperty(key);
            assert (value != null);
            props.setProperty(key, value);
        }
    }
}

