/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.openconcerto.utils.StreamUtils;

public class ProcessStreams
implements AutoCloseable {
    private static final int MAX_SHUTTING_DOWN_DELAY = 500;
    public static final ProcessBuilder.Redirect DISCARD = ProcessBuilder.Redirect.to(StreamUtils.NULL_FILE);
    private final ExecutorService exec = Executors.newFixedThreadPool(2);
    private final Process process;
    private Future<?> out;
    private Future<?> err;

    public static final ProcessBuilder redirect(ProcessBuilder pb) {
        return pb.redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT);
    }

    public static final Process consume(Process proc) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ProcessStreams streams = new ProcessStreams(proc);){
                streams.start(StreamUtils.NULL_OS, StreamUtils.NULL_OS);
                streams.awaitTermination();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't consume output of " + proc, e);
        }
        return proc;
    }

    public ProcessStreams(Process p) {
        this.process = p;
    }

    public final ProcessStreams start(OutputStream out, OutputStream err) {
        if (this.out != null) {
            throw new IllegalStateException("Already started");
        }
        this.out = this.writeToAsync(this.process::getInputStream, out);
        this.err = this.writeToAsync(this.process::getErrorStream, err);
        assert (this.out != null && this.err != null);
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        ProcessStreams.this.out.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        ProcessStreams.this.err.get();
                    }
                    catch (Exception exception) {}
                }
                finally {
                    ProcessStreams.this.exec.shutdown();
                }
            }
        });
        return this;
    }

    protected final void stopOut() {
        this.stop(this.out);
    }

    protected final void stopErr() {
        this.stop(this.err);
    }

    private final void stop(Future<?> f) {
        if (f == null) {
            throw new IllegalStateException("Not started");
        }
        f.cancel(true);
    }

    @Override
    public void close() {
        this.exec.shutdownNow();
    }

    public final void awaitTermination() throws InterruptedException, ExecutionException {
        this.out.get();
        this.err.get();
        if (!this.exec.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Executor still not terminated after 500");
        }
    }

    public final void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.out.get(timeout, unit);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        try {
            this.err.get(timeout, unit);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (!this.exec.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Executor still not terminated after 500");
        }
    }

    private final Future<?> writeToAsync(final Supplier<InputStream> insSupplier, final Object outs) {
        if (outs == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.exec.submit(new Callable<Object>(){

            @Override
            public Void call() throws InterruptedException, IOException {
                block11: {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    InputStream ins = (InputStream)insSupplier.get();
                    try {
                        if (outs instanceof PrintStream) {
                            ProcessStreams.writeTo(ins, (PrintStream)outs);
                        } else {
                            StreamUtils.copy(ins, (OutputStream)outs);
                        }
                        if (ins == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (ins != null) {
                                ins.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    ins.close();
                }
                return null;
            }
        });
    }

    public static final void writeTo(InputStream ins, PrintStream outs) throws InterruptedException, IOException {
        String encodedName;
        BufferedReader r = new BufferedReader(new InputStreamReader(ins));
        while ((encodedName = r.readLine()) != null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            outs.println(encodedName);
        }
    }
}

