/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Comparator;
import org.openconcerto.utils.CompareUtils;

public final class ArrayComparator<C>
implements Comparator<Object[]> {
    private final int i;
    private final Class<C> clazz;
    private final Comparator<? super C> comp;

    public static <T extends Comparable<? super T>> ArrayComparator<T> createNatural(int i, Class<T> clazz) {
        return new ArrayComparator<T>(i, clazz, CompareUtils.naturalOrder());
    }

    public ArrayComparator(int i, Class<C> clazz, Comparator<? super C> comp) {
        if (i < 0) {
            throw new IllegalArgumentException("Negative index : " + i);
        }
        this.i = i;
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        this.clazz = clazz;
        if (comp == null) {
            throw new IllegalArgumentException("Null comparator");
        }
        this.comp = comp;
    }

    @Override
    public int compare(Object[] o1, Object[] o2) {
        C i1 = this.clazz.cast(o1[this.i]);
        C i2 = this.clazz.cast(o2[this.i]);
        return this.comp.compare(i1, i2);
    }
}

