/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CloseTableHeaderRenderer
extends JPanel
implements TableCellRenderer,
MouseListener {
    private ImageIcon icon1 = new ImageIcon(CloseTableHeaderRenderer.class.getResource("remove.png"));
    private ImageIcon icon2 = new ImageIcon(CloseTableHeaderRenderer.class.getResource("remove2.png"));
    private final JButton b = new JButton(this.icon1);
    private JTableHeader header;
    private JTable editedTable;
    private int editedColumn;
    private JLabel label = new JLabel();
    private List popupActions;

    public CloseTableHeaderRenderer(final Action buttonAction, List popupActions) {
        this.popupActions = popupActions;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 2, 0, 1);
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.label, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.b.setBorder(null);
        this.b.setFocusable(false);
        this.b.setOpaque(false);
        this.b.setMargin(new Insets(1, 1, 1, 1));
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonAction.actionPerformed(e);
            }
        });
        this.add((Component)this.b, c);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.header = table.getTableHeader();
        this.header.setReorderingAllowed(false);
        this.editedTable = table;
        this.editedColumn = column;
        this.label.setText(String.valueOf(value));
        this.header.removeMouseListener(this);
        this.header.addMouseListener(this);
        return this;
    }

    public void destroy() {
        this.header.removeMouseListener(this);
        this.editedTable = null;
        this.header = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.header == null) {
            return;
        }
        int col = this.header.columnAtPoint(e.getPoint());
        if (col < 0) {
            return;
        }
        TableColumn tcol = this.editedTable.getColumnModel().getColumn(col);
        System.out.println(tcol.getHeaderValue());
        int x = 0;
        int i = 0;
        while (i < this.editedColumn) {
            TableColumn acol = this.editedTable.getColumnModel().getColumn(i);
            x += acol.getWidth();
            ++i;
        }
        System.out.println("p:" + (e.getX() - x) + "," + e.getY());
        System.out.println("p:" + this.getBounds());
        boolean test = this.b.getBounds().contains(e.getX() - x, e.getY());
        System.out.println(test);
        if (test) {
            this.b.doClick();
        } else if (e.getButton() == 3 && new Rectangle(-this.getBounds().x, -this.getBounds().y).contains(e.getX() - x, e.getY())) {
            JPopupMenu pop = new JPopupMenu();
            int i2 = 0;
            while (i2 < this.popupActions.size()) {
                pop.add((Action)this.popupActions.get(i2));
                ++i2;
            }
            pop.show(this.header, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

