/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group.modifier;

import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.GroupModifier;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHintsBuilder;
import org.openconcerto.ui.group.modifier.ItemGroupModifier;

public class LocalHintsPropertyModifier
extends ItemGroupModifier {
    private boolean b;
    private String property;
    public static final String FILLWIDTH = "fillWidth";
    public static final String FILLHEIGHT = "fillHeight";
    public static final String LARGEWIDTH = "largeWitdh";
    public static final String LARGEHEIGHT = "largeHeight";
    public static final String SEPARATED = "separated";
    public static final String SHOWLABEL = "showLabel";

    public LocalHintsPropertyModifier(String itemId, String property, boolean b) {
        super(itemId);
        this.b = b;
        if (property == null) {
            throw new IllegalArgumentException("null property");
        }
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    @Override
    public void applyOn(Group g) {
        Item it = g.getDescFromID(this.getItemId());
        LayoutHintsBuilder localHint = it.getLocalHint().getBuilder();
        if (this.property.equals(FILLWIDTH)) {
            localHint.setFillWidth(this.b);
        } else if (this.property.equals(FILLHEIGHT)) {
            localHint.setFillHeight(this.b);
        } else if (this.property.equals(LARGEWIDTH)) {
            localHint.setLargeWidth(this.b);
        } else if (this.property.equals(LARGEHEIGHT)) {
            localHint.setLargeHeight(this.b);
        } else if (this.property.equals(SEPARATED)) {
            localHint.setSeparated(this.b);
        } else if (this.property.equals(SHOWLABEL)) {
            localHint.setShowLabel(this.b);
        } else {
            throw new IllegalStateException("Unknown property:" + this.getProperty());
        }
        it.setLocalHint(localHint.build());
    }

    @Override
    public boolean canBeAppliedOn(Group g) {
        return g.contains(this.getItemId());
    }

    @Override
    public boolean isCompatibleWith(GroupModifier g) {
        if (g instanceof LocalHintsPropertyModifier) {
            return !((LocalHintsPropertyModifier)g).getItemId().equals(this.getItemId()) && !((LocalHintsPropertyModifier)g).getProperty().equals(this.getProperty());
        }
        return true;
    }
}

