/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.LayoutHints;

public class Item {
    private String id;
    @GuardedBy(value="this")
    private boolean frozen;
    private Group parent;
    private LayoutHints localHint;

    public static Item copy(Item item, Group newParent) {
        return item instanceof Group ? Group.copy((Group)item, newParent) : new Item(item, newParent);
    }

    public Item(String id) {
        this(id, null);
    }

    public Item(String id, LayoutHints hint) {
        this.id = id.trim();
        this.frozen = false;
        this.setLocalHint(hint);
    }

    public Item(Item item, Group newParent) {
        this.id = item.id;
        this.frozen = false;
        this.parent = newParent;
        this.setLocalHint(item.localHint);
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.checkFrozen("setId");
        this.id = id;
    }

    public final synchronized boolean isFrozen() {
        return this.frozen;
    }

    protected final void checkFrozen(String op) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Frozen cannot " + op);
        }
    }

    public final synchronized void freeze() {
        if (this.getParent() != null) {
            throw new IllegalStateException("Can only freeze from the root down");
        }
        this._freeze();
    }

    protected synchronized void _freeze() {
        this.frozen = true;
    }

    public final Item getChildFromID(String id) {
        return this.getDescFromID(id, 1);
    }

    public Collection<Item> getDescendantItems() {
        return Collections.singletonList(this);
    }

    protected void getDescendantItems(Collection<Item> res) {
        res.add(this);
    }

    public final Item getDescFromID(String id) {
        return this.getDescFromID(id, -1);
    }

    public Item getDescFromID(String id, int maxLevel) {
        return this.getId().equals(id) ? this : null;
    }

    public Group getParent() {
        return this.parent;
    }

    final void setParent(Group parent) {
        this.checkFrozen("setParent");
        this.parent = parent;
    }

    public LayoutHints getLocalHint() {
        return this.localHint;
    }

    public void setLocalHint(LayoutHints localHint) {
        this.checkFrozen("setLocalHint");
        this.localHint = new LayoutHints(localHint == null ? LayoutHints.DEFAULT_FIELD_HINTS : localHint);
    }

    public final void applyUntilRoot(Consumer<Item> cons) {
        Item current = this;
        while (current != null) {
            cons.accept(current);
            current = current.getParent();
        }
    }

    public final List<String> getAbsolutePath() {
        LinkedList<String> res = new LinkedList<String>();
        this.applyUntilRoot(item -> res.addFirst(item.getId()));
        return res;
    }

    public final Group getRoot() {
        AtomicReference current = new AtomicReference();
        this.applyUntilRoot(item -> current.set(item));
        return current.get() instanceof Group ? (Group)current.get() : null;
    }

    protected void printTree(StringBuilder builder, int localOrder, int level) {
        int i = 0;
        while (i < level - 1) {
            builder.append("  ");
            ++i;
        }
        builder.append("+-- ");
        builder.append(String.valueOf(localOrder) + " " + this.getId() + " [" + this.localHint + "]\n");
    }

    protected int printColumns(StringBuilder builder, int width, int x, int localOrder, int level) {
        if (this.localHint.largeWidth() && x > 0) {
            builder.append("\n");
            x = 0;
        }
        builder.append(" (" + x + ")");
        builder.append(String.valueOf(localOrder) + " " + this.getId() + "[" + this.localHint + "]");
        if (++x >= width || this.localHint.largeWidth()) {
            builder.append("\n");
            x = 0;
        }
        return x;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " '" + this.getId() + "'";
    }

    public boolean equalsDesc(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        return this.id.equals(other.id) && this.localHint.equals(other.localHint);
    }
}

