/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.openconcerto.ui.EnhancedTable;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class TextAreaRenderer
extends DefaultTableCellRenderer {
    public static final Color couleurFacture = new Color(225, 254, 207);
    public static final Color couleurFactureMore = new Color(215, 244, 197);
    public static final Color couleurFactureDark = couleurFacture.darker();
    public static final Color couleurBon = new Color(253, 243, 204);
    public static final Color couleurBonMore = new Color(243, 233, 194);
    public static final Color couleurBonDark = couleurBon.darker();
    final JTextArea area = UIManager.getLookAndFeel().getName().equalsIgnoreCase("nimbus") ? new JTextArea(){

        @Override
        protected void paintComponent(Graphics g) {
            Color c = g.getColor();
            Color background = this.getBackground();
            g.setColor(background);
            g.fillRect(0, 0, TextAreaRenderer.this.area.getWidth(), TextAreaRenderer.this.area.getHeight());
            g.setColor(c);
            super.paintComponent(g);
        }
    } : new JTextArea();
    private JTable currentTable;
    private int currentRow;

    public TextAreaRenderer() {
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension e = this.area.getPreferredSize();
        EnhancedTable eTable = (EnhancedTable)this.currentTable;
        Dimension r = new Dimension(e.width, Math.max(e.height, eTable.getMaxRowHeight(this.currentRow)));
        return r;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setColors(this, table, isSelected);
        this.currentTable = table;
        this.currentRow = row;
        this.setHorizontalAlignment(2);
        this.area.setForeground(new Color(this.getForeground().getRGB()));
        this.area.setBackground(new Color(this.getBackground().getRGB()));
        this.area.setFont(this.getFont());
        this.area.setBorder(null);
        this.area.setMargin(null);
        this.area.setText(value == null ? "" : (String)value);
        EnhancedTable eTable = (EnhancedTable)table;
        TableColumnModel columnModel = table.getColumnModel();
        this.area.setSize(columnModel.getColumn(column).getWidth(), 165863);
        int height_wanted = (int)this.area.getPreferredSize().getHeight();
        eTable.setPreferredRowHeight(row, column, height_wanted);
        eTable.setRowHeight(row, eTable.getMaxRowHeight(row));
        return this.area;
    }
}

