/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class PopupUtils {
    static Point adjustPopupLocationToFitScreen(Component invoker, Dimension preferredSize, int xposition, int yposition) {
        Rectangle screenBounds;
        Insets screenInsets;
        Point p = new Point(xposition, yposition);
        if (GraphicsEnvironment.isHeadless()) {
            return p;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        int i = 0;
        while (i < gd.length) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() == 0 && (dgc = gd[i].getDefaultConfiguration()).getBounds().contains(p)) {
                gc = dgc;
                break;
            }
            ++i;
        }
        if (gc == null && invoker != null) {
            gc = invoker.getGraphicsConfiguration();
        }
        if (gc != null) {
            screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
        } else {
            screenInsets = new Insets(0, 0, 0, 0);
            screenBounds = new Rectangle(toolkit.getScreenSize());
        }
        int scrWidth = screenBounds.width - Math.abs(screenInsets.left + screenInsets.right);
        int scrHeight = screenBounds.height - Math.abs(screenInsets.top + screenInsets.bottom);
        Dimension size = preferredSize;
        long pw = (long)p.x + (long)size.width;
        long ph = (long)p.y + (long)size.height;
        if (pw > (long)(screenBounds.x + scrWidth)) {
            p.x = screenBounds.x + scrWidth - size.width;
        }
        if (ph > (long)(screenBounds.y + scrHeight)) {
            p.y = screenBounds.y + scrHeight - size.height;
        }
        if (p.x < screenBounds.x) {
            p.x = screenBounds.x;
        }
        if (p.y < screenBounds.y) {
            p.y = screenBounds.y;
        }
        return p;
    }

    public static Popup createPopup(Component invoker, Component content, int x, int y) {
        Point p = PopupUtils.adjustPopupLocationToFitScreen(invoker, content.getPreferredSize(), x, y);
        return PopupFactory.getSharedInstance().getPopup(invoker, content, p.x, p.y);
    }
}

