/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.search;

import java.util.Date;
import java.util.List;
import org.openconcerto.sql.view.search.SearchSpec;

public class DateSearchSpec
implements SearchSpec {
    private final boolean excludeFilterString;
    private final int columnIndex;
    private final Date fromDate;
    private final Date toDate;

    public DateSearchSpec(Date from, Date to, int columnIndex) {
        this(false, from, to, columnIndex);
    }

    public DateSearchSpec(boolean excludeFilterString, Date from, Date to, int columnIndex) {
        this.excludeFilterString = excludeFilterString;
        this.fromDate = new Date(from.getTime());
        this.toDate = new Date(to.getTime());
        this.columnIndex = columnIndex;
    }

    private static boolean contains(Object line, Date startDate, Date stopDate, int index) {
        int stop;
        int start;
        List list = (List)line;
        if (index < 0) {
            start = 0;
            stop = list.size();
        } else {
            start = index;
            stop = index + 1;
        }
        int i = start;
        while (i < stop) {
            Object cell = list.get(i);
            if (cell != null) {
                if (cell instanceof Date) {
                    Date date = (Date)cell;
                    if (date.after(startDate) && date.before(stopDate)) {
                        return true;
                    }
                } else {
                    throw new IllegalArgumentException("The value is not a Date:" + cell + " index:" + index);
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean match(Object line) {
        return this.excludeFilterString ^ DateSearchSpec.contains(line, this.fromDate, this.toDate, this.columnIndex);
    }

    public void dump() {
        System.out.println(String.valueOf(this.excludeFilterString) + ":" + this.fromDate + "->" + this.toDate + " col:" + this.columnIndex);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }
}

