/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;

public final class DropTable
extends ChangeTable<DropTable> {
    private final SQLTable t;

    public DropTable(SQLTable t) {
        super(t.getDBSystemRoot().getSyntax(), t.getDBRoot().getName(), t.getName());
        this.t = t;
    }

    private final AlterTable getAlterTable() {
        AlterTable alterTable = new AlterTable(this.t);
        for (Constraint c : this.t.getAllConstraints()) {
            if (c.getType().equals((Object)SQLSyntax.ConstraintType.FOREIGN_KEY)) {
                if (c.getName() == null) {
                    throw new IllegalStateException(c + " is not a real constraint, use AddFK");
                }
                alterTable.dropForeignConstraint(c.getName());
                continue;
            }
            if (!c.getType().equals((Object)SQLSyntax.ConstraintType.UNIQUE) && !c.getType().equals((Object)SQLSyntax.ConstraintType.CHECK)) continue;
            alterTable.dropConstraint(c.getName());
        }
        return alterTable;
    }

    @Override
    public String asString(ChangeTable.NameTransformer transf) {
        return "DROP TABLE " + transf.transformTableName(new SQLName(this.getRootName(), this.getName())).quote() + ";";
    }

    @Override
    public String asString(ChangeTable.NameTransformer transf, ChangeTable.ConcatStep step) {
        switch (step) {
            case DROP_CONSTRAINT: {
                return this.getAlterTable().asString(transf, step);
            }
            case ALTER_TABLE: {
                return this.asString(transf);
            }
        }
        return null;
    }

    @Override
    public DropTable addColumn(String name, String definition) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getConstraintPrefix() {
        throw new UnsupportedOperationException();
    }
}

