/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.navigator.RowsSQLBrowserColumn;
import org.openconcerto.sql.navigator.SQLBrowserColumn;
import org.openconcerto.sql.navigator.SQLBrowserListener;
import org.openconcerto.sql.navigator.SQLListModel;
import org.openconcerto.utils.cc.ITransformer;

public class SQLBrowser
extends JPanel {
    private final List<SQLBrowserColumn> columns = new Vector<SQLBrowserColumn>();
    private SQLBrowserColumn activeCol;
    private final JPanel minimizedPanel = new JPanel();
    private final JPanel mainPanel = new JPanel();
    private final Set<SQLBrowserListener> browserListeners = new HashSet<SQLBrowserListener>();
    private int maxVisibleColumn = 5;
    private final ITransformer<SQLElement, Collection<SQLField>> childrenTransf;
    private int selectionMode = 1;
    private final List<Action> actions = new ArrayList<Action>();

    public SQLBrowser(RowsSQLBrowserColumn root) {
        this(root, null);
    }

    public SQLBrowser(RowsSQLBrowserColumn root, ITransformer<SQLElement, Collection<SQLField>> childrenTransf) {
        this.childrenTransf = childrenTransf;
        this.activeCol = null;
        this.setBackground(new Color(255, 251, 242));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.ipadx = 1;
        this.add((Component)this.minimizedPanel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.mainPanel, c);
        this.minimizedPanel.setLayout(new GridLayout(1, 1));
        this.mainPanel.setBackground(new Color(140, 141, 121));
        GridLayout grid = new GridLayout(1, 1);
        grid.setHgap(1);
        this.mainPanel.setLayout(grid);
        this.minimizedPanel.setVisible(false);
        this.actions.add(this.createColumnAction(0, 112));
        this.actions.add(this.createColumnAction(1, 113));
        this.actions.add(this.createColumnAction(2, 114));
        this.actions.add(this.createColumnAction(3, 115));
        this.addChangeAction(0, 112, 113);
        this.addChangeAction(1, 114, 115);
        this.addChangeAction(2, 116, 117);
        this.addChangeAction(3, 118, 119);
        root.reload();
        this.addColumn(root, null);
    }

    public void setMaxVisibleColumn(int i) {
        this.maxVisibleColumn = i;
    }

    public void addColumn(SQLBrowserColumn col, SQLBrowserColumn after) {
        if (after != null) {
            if (after.next() == col) {
                col.deselect();
                this.rmColumnAfter(col);
                return;
            }
            this.rmColumnAfter(after);
        }
        if (!this.columns.contains(col)) {
            col.setParentBrowser(this);
            col.setSelectionMode(Math.min(col.getSelectionMode(), this.selectionMode));
            this.columns.add(col);
            this.addColToGUI(col);
            this.minimizeExtraColumns();
        }
    }

    private void addColToGUI(SQLBrowserColumn col) {
        this.mainPanel.add(col);
        col.setShortcut("F" + this.mainPanel.getComponentCount());
    }

    public void rmColumnAfter(SQLBrowserColumn col) {
        if (col == null) {
            throw new NullPointerException("from null");
        }
        int index = this.columns.indexOf(col);
        int i = this.columns.size() - 1;
        while (i > index) {
            SQLBrowserColumn e = this.columns.get(i);
            e.setParentBrowser(null);
            this.columns.remove(i);
            this.mainPanel.remove(e);
            --i;
        }
        this.revalidate();
    }

    private void rebuild() {
        this.minimizedPanel.removeAll();
        this.mainPanel.removeAll();
        int i = 0;
        while (i < this.columns.size()) {
            SQLBrowserColumn col = this.columns.get(i);
            if (col.isMinimized()) {
                this.minimizedPanel.add(col);
                this.minimizedPanel.setVisible(true);
            } else {
                this.addColToGUI(col);
            }
            ++i;
        }
        this.revalidate();
    }

    protected final SQLBrowserColumn<?, ?> getActiveColumn() {
        return this.activeCol;
    }

    public List<SQLBrowserColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<SQLBrowserColumn> getVisibleColumns() {
        int minimizedCount = this.minimizedPanel.getComponentCount();
        return Collections.unmodifiableList(this.columns.subList(minimizedCount, this.columns.size()));
    }

    public SQLBrowserColumn getLastColumn() {
        return this.columns.get(this.columns.size() - 1);
    }

    private RowsSQLBrowserColumn getFirstColumn() {
        return (RowsSQLBrowserColumn)this.getColumns().get(0);
    }

    private void minimizeExtraColumns() {
        int extraColsCount = this.columns.size() - this.maxVisibleColumn;
        if (extraColsCount > 0) {
            int i = 0;
            while (i < extraColsCount) {
                SQLBrowserColumn col = this.columns.get(i);
                col.setMinimizedState(true);
                ++i;
            }
            this.rebuild();
        }
    }

    public void maximizeFrom(SQLBrowserColumn column) {
        this.minMax(column, true);
        column.setActive();
    }

    private void minMax(SQLBrowserColumn column, boolean max) {
        int index = this.columns.indexOf(column);
        int start = max ? index : 0;
        int stop = max ? this.columns.size() : index;
        int i = start;
        while (i < stop) {
            SQLBrowserColumn col = this.columns.get(i);
            col.setMinimizedState(!max);
            ++i;
        }
        this.rebuild();
    }

    public void minimizeUntil(SQLBrowserColumn column) {
        this.minMax(column, false);
    }

    public void addSQLBrowserListener(SQLBrowserListener l) {
        this.browserListeners.add(l);
    }

    public void removeSQLBrowserListener(SQLBrowserListener l) {
        this.browserListeners.remove(l);
    }

    void fireSQLBrowserColumnSelected(SQLBrowserColumn col) {
        for (SQLBrowserListener element : this.browserListeners) {
            element.columnSelected(col);
        }
    }

    public void activate(SQLBrowserColumn column) {
        if (column != null) {
            if (column.isMinimized()) {
                this.maximizeFrom(column);
            }
            column.activate();
        }
    }

    public void activateVisibleColumn(int index) {
        List<SQLBrowserColumn> cols = this.getVisibleColumns();
        if (index >= cols.size()) {
            index = cols.size() - 1;
        }
        this.activate(cols.get(index));
    }

    void columnFocusChanged(SQLBrowserColumn col, boolean gained) {
        if (this.activeCol == col && !gained) {
            this.activeCol = null;
        } else if (this.activeCol != col && gained) {
            this.activeCol = col;
        }
    }

    public void setSelectedRow(SQLRow r) {
        if (r != null) {
            this.selectPath(this.getPath(r));
        }
    }

    private List<SQLRow> getPath(SQLRow r) {
        if (r == null) {
            return Collections.emptyList();
        }
        RowsSQLBrowserColumn first = this.getFirstColumn();
        ArrayList<SQLRow> path = new ArrayList<SQLRow>();
        SQLRow currentRow = r;
        while (currentRow != null && !first.getElement().equals(SQLBrowser.getElement(currentRow.getTable()))) {
            path.add(0, currentRow);
            currentRow = SQLBrowser.getElement(currentRow.getTable()).getForeignParent(currentRow);
        }
        if (currentRow == null) {
            throw new IllegalArgumentException(r + " is not a children of " + first);
        }
        path.add(0, currentRow);
        return path;
    }

    private void selectPath(List<SQLRow> path) {
        this.getFirstColumn().setSelectedRow(null);
        for (SQLRow r : path) {
            this.getLastColumn().setSelectedRow(r);
        }
    }

    static SQLElement getElement(SQLTable t) {
        return Configuration.getInstance().getDirectory().getElement(t);
    }

    public void dump(PrintStream p) {
        int i = 0;
        while (i < this.columns.size()) {
            SQLBrowserColumn col = this.columns.get(i);
            p.println(String.valueOf(i) + " :::" + col);
            ++i;
        }
    }

    public List<SQLTable> getTablesBefore(SQLBrowserColumn stopCol) {
        ArrayList<SQLTable> result = new ArrayList<SQLTable>();
        int i = 0;
        while (i < this.columns.size()) {
            SQLBrowserColumn col = this.columns.get(i);
            if (col == stopCol) break;
            if (col instanceof RowsSQLBrowserColumn) {
                result.add(((RowsSQLBrowserColumn)col).getTable());
            }
            ++i;
        }
        return result;
    }

    public List<SQLRow> getFirstSelectedRows() {
        ArrayList<SQLRow> result = new ArrayList<SQLRow>();
        int i = 0;
        while (i < this.columns.size()) {
            SQLRow firstSelectedRow;
            SQLBrowserColumn col = this.columns.get(i);
            if (col instanceof RowsSQLBrowserColumn && (firstSelectedRow = ((RowsSQLBrowserColumn)col).getFirstSelectedRow()) != null) {
                result.add(firstSelectedRow);
            }
            ++i;
        }
        return result;
    }

    public List<SQLRow> getSelectedRows() {
        ArrayList<SQLBrowserColumn> reverse = new ArrayList<SQLBrowserColumn>(this.columns);
        Collections.reverse(reverse);
        for (SQLBrowserColumn col : reverse) {
            if (col.getSelectedRows().isEmpty()) continue;
            return col.getSelectedRows();
        }
        return Collections.emptyList();
    }

    public List<SQLRow> getLastMeaningfullRows() {
        SQLBrowserColumn col = this.getLastMeaningfullCol();
        return col == null ? Collections.emptyList() : col.getUserSelectedRows();
    }

    public List<Set<SQLRow>> getMeaningfullRows() {
        SQLBrowserColumn col = this.getLastMeaningfullCol();
        if (col == null) {
            return Collections.emptyList();
        }
        ArrayList<Set<SQLRow>> res = new ArrayList<Set<SQLRow>>();
        res.add(new HashSet<SQLRow>(col.getUserSelectedRows()));
        RowsSQLBrowserColumn c = col.previousRowsColumn();
        while (c != null) {
            HashSet<SQLRow> highlighted = ((SQLListModel)c.getModel()).getHighlighted();
            res.add((Set<SQLRow>)(!highlighted.isEmpty() ? highlighted : new HashSet<SQLRow>(c.getUserSelectedRows())));
            c = c.previousRowsColumn();
        }
        return res;
    }

    private final SQLBrowserColumn getLastMeaningfullCol() {
        ArrayList<SQLBrowserColumn> reverse = new ArrayList<SQLBrowserColumn>(this.columns);
        Collections.reverse(reverse);
        for (SQLBrowserColumn col : reverse) {
            List<SQLRow> selectedRows = col.getUserSelectedRows();
            if (selectedRows.isEmpty() || col.isAllSelected() && !col.isSearched()) continue;
            return col;
        }
        return null;
    }

    public final ITransformer<SQLElement, Collection<SQLField>> getChildrenTransformer() {
        return this.childrenTransf;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        int i = 0;
        while (i < this.columns.size()) {
            SQLBrowserColumn col = this.columns.get(i);
            col.setSelectionMode(this.selectionMode);
            ++i;
        }
    }

    public final List<Action> getActions() {
        return this.actions;
    }

    private final void addChangeAction(int colIndex, int keyUp, int keyDown) {
        this.actions.add(this.createChangeFilterAction(colIndex, KeyStroke.getKeyStroke(keyUp, 128), true));
        this.actions.add(this.createChangeFilterAction(colIndex, KeyStroke.getKeyStroke(keyDown, 128), false));
    }

    private Action createColumnAction(int colIndex, int key) {
        return this.createColumnAction(colIndex, KeyStroke.getKeyStroke(key, 0));
    }

    private Action createColumnAction(final int colIndex, KeyStroke key) {
        return new AbstractAction(key){
            {
                this.putValue("Name", "select col " + n + " of " + SQLBrowser.this);
                this.putValue("ActionCommandKey", "Column" + n + "[" + keyStroke + "]");
                this.putValue("AcceleratorKey", keyStroke);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Frame)SwingUtilities.getAncestorOfClass(Frame.class, SQLBrowser.this)).setExtendedState(0);
                SwingUtilities.getWindowAncestor(SQLBrowser.this).toFront();
                SQLBrowser.this.activateVisibleColumn(colIndex);
            }
        };
    }

    private Action createChangeFilterAction(final int colIndex, KeyStroke key, final boolean up) {
        return new AbstractAction(key){
            {
                this.putValue("Name", "change selection of col " + n + " of " + SQLBrowser.this);
                this.putValue("ActionCommandKey", "Change Column" + n + "[" + keyStroke + "]");
                this.putValue("AcceleratorKey", keyStroke);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLBrowserColumn> cols = SQLBrowser.this.getVisibleColumns();
                if (colIndex < cols.size()) {
                    cols.get(colIndex).select(!up);
                }
            }
        };
    }
}

