/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.StringUtils;

@Immutable
public class Where {
    public static final Where FALSE = Where.createRaw("1=0", new FieldRef[0]);
    public static final Where TRUE = Where.createRaw("1=1", new FieldRef[0]);
    public static final String NULL_IS_DATA_EQ = new String("===");
    public static final String NULL_IS_DATA_NEQ = new String("IS DISTINCT FROM");
    private static Combiner AndCombiner = new Combiner(){

        @Override
        protected Where combineNotNull(Where where1, Where where2) {
            return where1.and(where2);
        }
    };
    private static Combiner OrCombiner = new Combiner(){

        @Override
        protected Where combineNotNull(Where where1, Where where2) {
            return where1.or(where2);
        }
    };
    private final List<FieldRef> fields;
    private final String clause;

    private static Where combine(Collection<Where> wheres, Combiner c) {
        Where res = null;
        for (Where w : wheres) {
            res = c.combine(res, w);
        }
        return res;
    }

    public static Where and(Collection<Where> wheres) {
        return Where.combine(wheres, AndCombiner);
    }

    public static Where and(SQLTable t, Map<String, ?> fields) {
        ArrayList<Where> res = new ArrayList<Where>(fields.size());
        for (Map.Entry<String, ?> e : fields.entrySet()) {
            res.add(new Where((FieldRef)t.getField(e.getKey()), "=", e.getValue()));
        }
        return Where.and(res);
    }

    public static Where or(Collection<Where> wheres) {
        return Where.combine(wheres, OrCombiner);
    }

    public static Where and(Where where1, Where where2) {
        return AndCombiner.combine(where1, where2);
    }

    public static Where or(Where where1, Where where2) {
        return OrCombiner.combine(where1, where2);
    }

    public static Where isNull(FieldRef ref) {
        return new Where(ref, "is", (Object)null);
    }

    public static Where isNotNull(FieldRef ref) {
        return new Where(ref, "is not", (Object)null);
    }

    public static Where between(FieldRef ref, FieldRef lowerBound, FieldRef upperBound) {
        return Where.createRaw(String.valueOf(ref.getFieldRef()) + " BETWEEN " + lowerBound.getFieldRef() + " AND " + upperBound.getFieldRef(), ref, lowerBound, upperBound);
    }

    public static Where inSubqueries(FieldRef ref, List<String> subQueries) {
        return Where.subqueries(ref, true, subQueries);
    }

    public static Where notInSubqueries(FieldRef ref, List<String> subQueries) {
        return Where.subqueries(ref, false, subQueries);
    }

    public static Where inValues(FieldRef ref, Collection<?> values) {
        return Where.compareValues(ref, RowComparison.IN, values);
    }

    public static Where notInValues(FieldRef ref, Collection<?> values) {
        return Where.compareValues(ref, RowComparison.NOT_IN, values);
    }

    public static Where compareValues(FieldRef ref, RowComparison cmp, Collection<?> values) {
        return Where.compareValues(ref, cmp, NullValue.IS_FORBIDDEN, values);
    }

    public static Where compareValues(FieldRef ref, RowComparison cmp, NullValue nullMode, Collection<?> values) {
        if (values.isEmpty()) {
            return cmp == RowComparison.IN ? FALSE : TRUE;
        }
        return Where.createRaw(Where.getCompareValuesClause(ref.getFieldRef(), cmp, nullMode, values, ref.getField().getType()), ref);
    }

    public static Where subqueries(FieldRef ref, boolean in, List<String> subQueries) {
        return Where.createRaw(Where.getInClause(ref, in, CollectionUtils.join(subQueries, "\nUNION\n")), ref);
    }

    public static Where createRaw(String clause, FieldRef ... refs) {
        return Where.createRaw(clause, Arrays.asList(refs));
    }

    public static Where createRaw(String clause, Collection<? extends FieldRef> refs) {
        if (clause == null) {
            return null;
        }
        return new Where(clause, refs);
    }

    public static Where quote(SQLSyntax s, String pattern, Object ... params) {
        ArrayList<FieldRef> fields = new ArrayList<FieldRef>();
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object param = objectArray[n2];
            if (param instanceof FieldRef) {
                fields.add((FieldRef)param);
            }
            ++n2;
        }
        return new Where(SQLBase.quote(s, pattern, params), fields);
    }

    private static final String normalizeOperator(String op) {
        String res = op.trim();
        if (res.equals("!=")) {
            res = "<>";
        }
        return res;
    }

    public static final String comparison(FieldRef ref, String op, String y) {
        return Where.comparison(null, ref.getField(), ref.getFieldRef(), op, y);
    }

    public static final String comparison(SQLSyntax s, String x, String op, String y) {
        return Where.comparison(Objects.requireNonNull(s, "Missing syntax"), null, x, op, y);
    }

    private static final String comparison(SQLSyntax s, DBStructureItem<?> syntaxSupplier, String x, String op, String y) {
        Objects.requireNonNull(op, "Missing operator");
        if (op == NULL_IS_DATA_EQ || op == NULL_IS_DATA_NEQ) {
            if (s == null) {
                s = syntaxSupplier.getDBSystemRoot().getSyntax();
            }
            return s.getNullIsDataComparison(x, op == NULL_IS_DATA_EQ, y);
        }
        return String.valueOf(x) + ' ' + op + ' ' + y;
    }

    private static final String getInClause(FieldRef field1, boolean in, String inParens) {
        return Where.getInClause(field1.getFieldRef(), in ? RowComparison.IN : RowComparison.NOT_IN, inParens);
    }

    private static final String getInClause(String expr, RowComparison cmp, String inParens) {
        String op = cmp == RowComparison.IN ? " in (" : " not in (";
        return String.valueOf(expr) + op + inParens + ')';
    }

    public static final String getCompareValuesClause(String expr, RowComparison cmp, Collection<?> values, SQLType type) {
        return Where.getCompareValuesClause(expr, cmp, NullValue.IS_FORBIDDEN, values, type);
    }

    public static final String getCompareValuesClause(String expr, RowComparison cmp, NullValue nullMode, Collection<?> values, SQLType type) {
        boolean addNull;
        if (nullMode != NullValue.IS_UNKNOWN && values.contains(null)) {
            if (nullMode == NullValue.IS_FORBIDDEN) {
                throw new IllegalArgumentException("Values contains a null value : " + values);
            }
            assert (nullMode == NullValue.IS_DATA);
            addNull = true;
        } else {
            addNull = false;
        }
        if (addNull) {
            values = values.stream().filter(i -> i != null).collect(Collectors.toList());
        }
        String res = Where.getInClause(expr, cmp, CollectionUtils.join(values, ",", input -> type.toString(input)));
        if (addNull) {
            res = cmp == RowComparison.IN ? String.valueOf(expr) + " is null or " + res : String.valueOf(expr) + " is not null and " + res;
        }
        return res;
    }

    public Where(FieldRef field1, String op, FieldRef field2) {
        this.fields = Arrays.asList(field1, field2);
        this.clause = Where.comparison(field1, Where.normalizeOperator(op), field2.getFieldRef());
    }

    public Where(FieldRef field1, String op, int scalar) {
        this(field1, op, (Object)scalar);
    }

    public Where(FieldRef ref, String op, Object o) {
        this.fields = Collections.singletonList(ref);
        op = Where.normalizeOperator(op);
        if (o == null) {
            if (op.equals("=")) {
                op = "is";
            } else if (op.equals("<>")) {
                op = "is not";
            }
        }
        this.clause = Where.comparison(ref, op, ref.getField().getType().toString(o));
    }

    public Where(FieldRef field1, Collection<?> values) {
        this(field1, true, values);
    }

    public Where(FieldRef field1, boolean in, Collection<?> values) {
        if (values.isEmpty()) {
            this.fields = Collections.emptyList();
            this.clause = in ? FALSE.getClause() : TRUE.getClause();
        } else {
            this.fields = Collections.singletonList(field1);
            this.clause = Where.getCompareValuesClause(field1.getFieldRef(), in ? RowComparison.IN : RowComparison.NOT_IN, values, field1.getField().getType());
        }
    }

    public Where(FieldRef field1, boolean in, SQLSelect subQuery) {
        this.fields = Collections.singletonList(field1);
        this.clause = Where.getInClause(field1, in, subQuery.asString());
    }

    public Where(FieldRef ref, Object borneInf, Object borneSup) {
        SQLField field1 = ref.getField();
        this.fields = Collections.singletonList(ref);
        this.clause = String.valueOf(ref.getFieldRef()) + " BETWEEN " + field1.getType().toString(borneInf) + " AND " + field1.getType().toString(borneSup);
    }

    public Where(FieldRef ref, Object borneInf, boolean infInclusive, Object borneSup, boolean supInclusive) {
        this.fields = Collections.singletonList(ref);
        String infClause = new Where(ref, infInclusive ? ">=" : ">", borneInf).getClause();
        String supClause = new Where(ref, supInclusive ? "<=" : "<", borneSup).getClause();
        this.clause = String.valueOf(infClause) + " AND " + supClause;
    }

    private Where(String clause, Collection<? extends FieldRef> refs) {
        if (StringUtils.isEmpty(clause, true)) {
            throw new IllegalArgumentException("No clause");
        }
        this.fields = Collections.unmodifiableList(new ArrayList<FieldRef>(refs));
        this.clause = clause;
    }

    public Where or(Where w) {
        return this.combine(w, "OR");
    }

    public Where and(Where w) {
        return this.combine(w, "AND");
    }

    public Where not() {
        return new Where("NOT (" + this.clause + ")", this.fields);
    }

    private Where combine(Where w, String op) {
        if (w == null) {
            return this;
        }
        ArrayList<FieldRef> fields = new ArrayList<FieldRef>();
        fields.addAll(this.fields);
        fields.addAll(w.fields);
        String clause = "(" + this.clause + ") " + op + " (" + w.clause + ")";
        return new Where(clause, fields);
    }

    public String getClause() {
        return this.clause;
    }

    public List<FieldRef> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.getClause();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Where o = (Where)obj;
        return this.getClause().equals(o.getClause()) && this.getFields().equals(o.getFields());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getClause().hashCode();
        result = 31 * result + this.getFields().hashCode();
        return result;
    }

    private static abstract class Combiner {
        private Combiner() {
        }

        public final Where combine(Where w1, Where w2) {
            if (w1 == null) {
                return w2;
            }
            return this.combineNotNull(w1, w2);
        }

        protected abstract Where combineNotNull(Where var1, Where var2);
    }

    public static enum NullValue {
        IS_DATA,
        IS_FORBIDDEN,
        IS_UNKNOWN;

    }

    public static enum RowComparison {
        IN,
        NOT_IN;

    }
}

