/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class ExportSageXimport
extends AbstractExport {
    private final DecimalFormat decimalFormat = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.UK));
    private List<Object[]> data;

    private String formatCents(Number n) {
        return this.decimalFormat.format(BigDecimal.valueOf(n.longValue()).movePointLeft(2));
    }

    public ExportSageXimport(DBRoot rootSociete) {
        super(rootSociete, "Ximport", ".txt");
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableJrnl.getField("CODE"));
        sel.addSelect(tableJrnl.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableCompte.getField("NOM"));
        sel.addSelect(tableMouvement.getField("NUMERO"));
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addFieldOrder(tableJrnl.getField("CODE"));
        sel.addFieldOrder(tableEcriture.getField("DATE"));
        sel.addFieldOrder(tableMouvement.getField("NUMERO"));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    @Override
    protected void export(OutputStream out) throws IOException {
        OutputStreamWriter bufOut = new OutputStreamWriter(out, StringUtils.ASCII);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        for (Object[] array : this.data) {
            int sign;
            long cents;
            String numeroMouvement = String.valueOf(array[5]);
            bufOut.write(ExportSageXimport.fixedLengthRightAlign(StringUtils.toAsciiString(numeroMouvement), 5));
            String codeJournal = String.valueOf(array[0]);
            bufOut.write(ExportSageXimport.fixedLengthLeftAlign(StringUtils.toAsciiString(codeJournal), 2));
            bufOut.write(dateFormat.format((Date)array[2]));
            bufOut.write("        ");
            bufOut.write("            ");
            String numeroCompte = String.valueOf(array[3]);
            bufOut.write(ExportSageXimport.fixedLengthLeftAlign(StringUtils.toAsciiString(numeroCompte), 11));
            String libelleEcriture = String.valueOf(array[6]);
            bufOut.write(ExportSageXimport.fixedLengthLeftAlign(StringUtils.toAsciiString(libelleEcriture), 25));
            long debit = ((Number)array[7]).longValue();
            long credit = ((Number)array[8]).longValue();
            if (debit > 0L && credit > 0L) {
                throw new IllegalStateException("debit et credit >0");
            }
            if (credit > 0L) {
                cents = credit;
                sign = 67;
            } else {
                cents = debit;
                sign = 68;
            }
            bufOut.write(ExportSageXimport.fixedLengthRightAlign(this.formatCents(cents), 13));
            ((Writer)bufOut).write(sign);
            bufOut.write("            ");
            bufOut.write("      ");
            String libelleCompte = String.valueOf(array[4]);
            bufOut.write(ExportSageXimport.fixedLengthLeftAlign(StringUtils.toAsciiString(libelleCompte), 34));
            bufOut.write("\r\n");
            ((Writer)bufOut).flush();
        }
    }
}

