/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.modules.DepSolverResultChooserPanel;
import org.openconcerto.erp.modules.JarModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModulePanel;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleTableModel;
import org.openconcerto.erp.modules.ModulesStateChange;
import org.openconcerto.erp.modules.ModulesStateChangeResult;
import org.openconcerto.erp.modules.Solutions;
import org.openconcerto.erp.panel.UserExitConf;
import org.openconcerto.sql.view.AbstractFileTransfertHandler;
import org.openconcerto.ui.component.WaitIndeterminatePanel;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public class AvailableModulesPanel {
    static final MessageFormat MODULE_FMT;

    static {
        ChoiceFormat choiceForm = new ChoiceFormat(new double[]{1.0, 2.0}, new String[]{"d'un module", "de {0} modules"});
        MODULE_FMT = new MessageFormat("{0}");
        MODULE_FMT.setFormatByArgumentIndex(0, choiceForm);
    }

    static JDialog displayDialog(JComponent parent, String text) {
        WaitIndeterminatePanel panel = new WaitIndeterminatePanel(text);
        final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(parent), Dialog.ModalityType.APPLICATION_MODAL);
        dialog.add(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(true);
            }
        });
        return dialog;
    }

    static boolean displayDenied(JComponent panel, String dialogTitle, String deniedMsg, boolean noneAllowed) {
        boolean done;
        if (noneAllowed) {
            JOptionPane.showMessageDialog(panel, deniedMsg, dialogTitle, 2);
            done = true;
        } else {
            int answer = JOptionPane.showConfirmDialog(panel, deniedMsg, dialogTitle, 2, 2);
            done = answer == 2;
        }
        return done;
    }

    static void applySolution(final ModuleManager mngr, final ModulePanel panel, final ModulesStateChange chosen, final ModuleManager.ModuleState targetState) {
        String dialogTitle = "Gestion des modules";
        int installSize = chosen.getReferencesToInstall().size();
        int uninstallSize = chosen.getReferencesToRemove().size();
        if (installSize == 0 && uninstallSize == 0) {
            JOptionPane.showMessageDialog(panel, "Aucun changement \u00e0 apporter", "Gestion des modules", 1);
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        if (uninstallSize > 0) {
            sb.append("D\u00e9sinstallation ");
            sb.append(MODULE_FMT.format(new Object[]{uninstallSize}));
        }
        if (installSize > 0) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("Installation ");
            sb.append(MODULE_FMT.format(new Object[]{installSize}));
        }
        sb.append(".");
        String msg = sb.toString();
        if (mngr.needExit(chosen)) {
            Gestion.askForExit(new UserExitConf(msg, true){

                @Override
                protected void afterWindowsClosed() throws Exception {
                    mngr.applyChange(chosen, targetState, true);
                }
            });
        } else {
            final JDialog dialog = AvailableModulesPanel.displayDialog(panel, msg);
            new SwingWorker<ModulesStateChangeResult, Object>(){

                @Override
                protected ModulesStateChangeResult doInBackground() throws Exception {
                    ModuleManager.ModuleState backgroundState = CompareUtils.min(targetState, ModuleManager.ModuleState.REGISTERED);
                    return mngr.applyChange(chosen, backgroundState);
                }

                @Override
                protected void done() {
                    try {
                        ModulesStateChangeResult res = (ModulesStateChangeResult)this.get();
                        if (res.getNotCreated().size() > 0) {
                            JOptionPane.showMessageDialog(panel, "Certains modules n'ont pu \u00eatre cr\u00e9\u00e9s : " + res.getNotCreated(), "Gestion des modules", 2);
                        }
                        if (targetState.compareTo(ModuleManager.ModuleState.STARTED) >= 0) {
                            try {
                                mngr.startFactories(res.getGraph().flatten());
                                mngr.setPersistentModules(chosen.getUserReferencesToInstall());
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle(panel, "Impossible de d\u00e9marrer les modules", e);
                            }
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(panel, "Impossible d'appliquer les changements", e);
                    }
                    panel.reload();
                    dialog.dispose();
                }
            }.execute();
        }
    }

    static final Action createInstallAction(final ModulePanel panel, final boolean onlyInstall) {
        return new AbstractAction("Installer"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String dialogTitle = "Installation de modules";
                Collection<ModuleTableModel.ModuleRow> checkedRows = panel.getSelection();
                if (checkedRows.isEmpty()) {
                    JOptionPane.showMessageDialog(panel, "Aucune ligne coch\u00e9e", "Installation de modules", 1);
                    return;
                }
                final ModuleManager mngr = panel.getModuleManager();
                final HashSet<ModuleReference> refs = new HashSet<ModuleReference>();
                HashSet<ModuleReference> deniedRefs = new HashSet<ModuleReference>();
                for (ModuleTableModel.ModuleRow f : checkedRows) {
                    if (!mngr.canCurrentUser(ModuleManager.ModuleAction.INSTALL, f)) {
                        deniedRefs.add(f.getRef());
                        continue;
                    }
                    refs.add(f.getRef());
                }
                if (deniedRefs.size() > 0 && AvailableModulesPanel.displayDenied(panel, "Installation de modules", "Ces modules ne peuvent \u00eatre install\u00e9s : " + deniedRefs, refs.size() == 0)) {
                    return;
                }
                if (!$assertionsDisabled && refs.size() <= 0) {
                    throw new AssertionError();
                }
                final JDialog depDialog = AvailableModulesPanel.displayDialog(panel, "Calcul des d\u00e9pendences");
                new SwingWorker<Solutions, Object>(){

                    @Override
                    protected Solutions doInBackground() throws Exception {
                        return mngr.getSolutions(refs, 5);
                    }

                    @Override
                    protected void done() {
                        depDialog.dispose();
                        try {
                            Solutions res = (Solutions)this.get();
                            if (res.getSolutions().size() == 0) {
                                JOptionPane.showMessageDialog(panel, "Aucune solution trouv\u00e9e", "Installation de modules", 2);
                            } else {
                                final DepSolverResultChooserPanel cPanel = new DepSolverResultChooserPanel(res.getSolutions());
                                cPanel.setRunnable(new Runnable(){

                                    @Override
                                    public void run() {
                                        AvailableModulesPanel.applySolution(mngr, panel, cPanel.getSolutionToApply(), onlyInstall ? ModuleManager.ModuleState.INSTALLED : ModuleManager.ModuleState.STARTED);
                                    }
                                });
                                JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(panel), Dialog.ModalityType.APPLICATION_MODAL);
                                dialog.add(cPanel);
                                dialog.pack();
                                dialog.setLocationRelativeTo(panel);
                                dialog.setVisible(true);
                            }
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle(panel, "Erreur lors de la recherche de solutions", e);
                        }
                    }
                }.execute();
            }
        };
    }

    static final TransferHandler createTransferHandler(final ModulePanel panel) {
        return new AbstractFileTransfertHandler(){

            @Override
            public void handleFile(File f) {
                if (!f.getName().endsWith(".jar")) {
                    JOptionPane.showMessageDialog(panel, "Impossible d'installer le module. Le fichier n'est pas un module.");
                    return;
                }
                List<File> dirs = panel.getModuleManager().getFolders();
                File dir = ModuleManager.getFolderToWrite(dirs);
                if (dir == null) {
                    if (dirs.isEmpty()) {
                        JOptionPane.showMessageDialog(panel, "Aucun dossier configur\u00e9");
                    } else {
                        JOptionPane.showMessageDialog(panel, "Impossible de cr\u00e9er le dossier des modules : " + dirs);
                    }
                    return;
                }
                File out = null;
                if (dir.canWrite()) {
                    try {
                        out = new File(dir, f.getName());
                        FileUtils.copyFile(f, out);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(panel, "Impossible d'installer le module.\n" + f.getAbsolutePath() + " vers " + dir.getAbsolutePath());
                        return;
                    }
                } else {
                    JOptionPane.showMessageDialog(panel, "Impossible d'installer le module.\nVous devez disposer des droits en \u00e9criture sur le dossier:\n" + dir.getAbsolutePath());
                    return;
                }
                try {
                    panel.getModuleManager().addFactory(new JarModuleFactory(out));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(panel, "Impossible d'int\u00e9grer le module.\n" + e.getMessage());
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        panel.reload();
                    }
                });
            }
        };
    }
}

