/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.IListButton;
import org.openconcerto.utils.StringUtils;

public class ContactMailMenu
extends JMenu {
    private final JTextComponent textComp;
    private SQLRow selectedRow;

    public ContactMailMenu(JTextComponent textComp) {
        this.textComp = textComp;
        this.setIcon(new ImageIcon(IListButton.class.getResource("liste.png")));
        this.init();
    }

    public void init() {
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent me) {
                ContactMailMenu.this.removeAll();
                ContactMailMenu.this.fill();
                ContactMailMenu.this.revalidate();
                ContactMailMenu.this.repaint();
                ContactMailMenu.this.doClick();
            }

            @Override
            public void menuDeselected(MenuEvent me) {
            }

            @Override
            public void menuCanceled(MenuEvent me) {
            }
        });
    }

    public void setSelectedRow(SQLRow selectedRow) {
        this.selectedRow = selectedRow;
    }

    private void fillTextComp() {
        StringBuffer buf = new StringBuffer();
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)this.getItem(i);
            if (item.isSelected() && item.isEnabled()) {
                buf.append(String.valueOf(item.getText()) + (i < itemCount - 1 ? ", " : ""));
            }
            ++i;
        }
        this.textComp.setText(buf.toString());
    }

    public void fill() {
        JCheckBoxMenuItem menuItem;
        List<String> mailsNonTrimed = StringUtils.fastSplit(this.textComp.getText(), ',');
        ArrayList<String> mails = new ArrayList<String>(mailsNonTrimed.size());
        for (String string : mailsNonTrimed) {
            String trim = string.trim();
            if (trim.length() <= 0) continue;
            mails.add(trim);
        }
        HashSet<String> lockedItems = new HashSet<String>();
        HashSet<String> items = new HashSet<String>();
        if (this.selectedRow != null) {
            SQLRow foreign = this.selectedRow.getForeign("ID_CLIENT");
            Collection contacts = foreign.getReferentRows(foreign.getTable().getTable("CONTACT"));
            for (SQLRow sqlRow : contacts) {
                String mail = sqlRow.getString("EMAIL");
                if (mail == null || mail.trim().length() <= 0) continue;
                if (sqlRow.getBoolean("ENVOI_RAPPORT_MAIL").booleanValue()) {
                    lockedItems.add(mail);
                    continue;
                }
                if (mails.contains(mail)) continue;
                items.add(mail);
            }
        }
        for (String item : lockedItems) {
            JCheckBoxMenuItem menuItemLocked = new JCheckBoxMenuItem(item);
            menuItemLocked.setSelected(true);
            menuItemLocked.setEnabled(false);
            this.add(menuItemLocked);
        }
        for (String mail : mails) {
            if (mail.trim().length() <= 0) continue;
            menuItem = new JCheckBoxMenuItem(mail);
            menuItem.setSelected(true);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContactMailMenu.this.fillTextComp();
                }
            });
            this.add(menuItem);
        }
        for (String item : items) {
            if (item.trim().length() <= 0) continue;
            menuItem = new JCheckBoxMenuItem(item);
            menuItem.setSelected(false);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContactMailMenu.this.fillTextComp();
                }
            });
            this.add(menuItem);
        }
    }
}

