/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.invoice.report.ReportingStockXmlSheet;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.ExceptionHandler;

public class RapportEtatDeStockDepotSelectionPanel
extends JPanel {
    JPanel pnlMain = new JPanel();
    JPanel pnlBottom = new JPanel();
    JLabel labDepots = new JLabel("D\u00e9p\u00f4ts");
    JButton butReport = new JButton("G\u00e9n\u00e9rer le rapport");
    JCheckBox chkTous = new JCheckBox("S\u00e9l\u00e9ctionner tous les d\u00e9p\u00f4ts");
    SQLRequestComboBox sqlreqDepots = new SQLRequestComboBox(false, 20);

    public RapportEtatDeStockDepotSelectionPanel(final ComptaPropsConfiguration conf) {
        GridBagLayout layThis = new GridBagLayout();
        this.setLayout(layThis);
        GridBagLayout layMain = new GridBagLayout();
        this.pnlMain.setLayout(layMain);
        GridBagLayout layBottom = new GridBagLayout();
        this.pnlBottom.setLayout(layBottom);
        GridBagConstraints gbcThis = new GridBagConstraints();
        gbcThis.weightx = 1.0;
        gbcThis.weighty = 1.0;
        gbcThis.gridheight = 1;
        gbcThis.gridwidth = 1;
        gbcThis.fill = 1;
        GridBagConstraints gbcBottom = new GridBagConstraints();
        gbcBottom.weightx = 1.0;
        gbcBottom.weighty = 1.0;
        gbcBottom.gridheight = 1;
        gbcBottom.gridwidth = 2;
        gbcBottom.fill = 1;
        GridBagConstraints gbcDefault = new GridBagConstraints();
        gbcDefault.weightx = 1.0;
        gbcDefault.gridheight = 1;
        gbcDefault.gridwidth = 1;
        gbcDefault.insets = new Insets(0, 4, 4, 4);
        gbcDefault.fill = 2;
        GridBagConstraints gbcButton = new GridBagConstraints();
        gbcButton.weightx = 1.0;
        gbcButton.weighty = 1.0;
        gbcButton.gridheight = 1;
        gbcButton.gridwidth = 1;
        gbcButton.insets = new Insets(0, 4, 4, 4);
        gbcButton.anchor = 14;
        this.setBackground(Color.DARK_GRAY);
        this.add((Component)this.pnlMain, gbcThis);
        gbcDefault.gridx = 0;
        gbcDefault.gridy = 0;
        this.pnlMain.add((Component)this.labDepots, gbcDefault);
        this.labDepots.setHorizontalAlignment(4);
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("NOM");
        ComboSQLRequest request = new ComboSQLRequest(conf.getDirectory().getElement("DEPOT_STOCK").getTable(), fields, null, conf.getDirectory());
        gbcDefault.gridx = 1;
        gbcDefault.gridy = 0;
        this.sqlreqDepots.uiInit(request);
        this.sqlreqDepots.setValue(DepotStockSQLElement.DEFAULT_ID);
        this.pnlMain.add((Component)this.sqlreqDepots, gbcDefault);
        gbcDefault.gridx = 1;
        gbcDefault.gridy = 1;
        this.chkTous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RapportEtatDeStockDepotSelectionPanel.this.chkTous.isSelected()) {
                    RapportEtatDeStockDepotSelectionPanel.this.sqlreqDepots.setEnabled(InteractionMode.DISABLED);
                } else {
                    RapportEtatDeStockDepotSelectionPanel.this.sqlreqDepots.setEnabled(InteractionMode.READ_WRITE);
                }
            }
        });
        this.pnlMain.add((Component)this.chkTous, gbcDefault);
        gbcBottom.gridx = 0;
        gbcBottom.gridy = 2;
        this.pnlMain.add((Component)this.pnlBottom, gbcBottom);
        gbcButton.gridx = 0;
        gbcButton.gridy = 0;
        this.butReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer intIDDepot = RapportEtatDeStockDepotSelectionPanel.this.sqlreqDepots.getValue();
                boolean bTousLesDepots = RapportEtatDeStockDepotSelectionPanel.this.chkTous.isSelected();
                try {
                    ReportingStockXmlSheet sheet = new ReportingStockXmlSheet(conf, intIDDepot, bTousLesDepots);
                    sheet.createDocumentAsynchronous().get();
                    sheet.openDocument(false);
                }
                catch (Exception excep) {
                    ExceptionHandler.handle("Erreur de traitement", excep);
                }
            }
        });
        this.pnlBottom.add((Component)this.butReport, gbcButton);
    }
}

