/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.account;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.component.TransfertGroupSQLComponent;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteField;
import org.openconcerto.erp.core.common.ui.AcompteRowItemView;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AdresseType;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.invoice.ui.FactureSituationItemTable;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class VenteFactureSituationSQLComponent
extends TransfertGroupSQLComponent {
    public static final String ID = "sales.invoice.partial";
    private PanelOOSQLComponent panelOO;
    JCheckBox box = new JCheckBox("partial");
    private SimpleDocumentListener listenerAcompteField;
    private TableModelListener listenerTable;
    JUniqueTextField numberField;
    private final SQLTable tableNum = this.getElement().getTable().getTable("NUMEROTATION_AUTO");

    public VenteFactureSituationSQLComponent(SQLElement element) {
        super(element, (Group)GlobalMapper.getInstance().get(ID));
    }

    public VenteFactureSituationSQLComponent(SQLElement element, Group p) {
        super(element, p);
    }

    @Override
    protected Set<String> createRequiredNames() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("ID_CLIENT");
        s.add("ID_COMMERCIAL");
        s.add("NUMERO");
        s.add("DATE");
        s.add("MONTANT_FACTURABLE");
        s.add("ID_MODE_REGLEMENT");
        return s;
    }

    @Override
    protected RowValuesTable getRowValuesTable() {
        return ((AbstractArticleItemTable)this.getEditor("sales.invoice.partial.items.list")).getRowValuesTable();
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        DeviseField totalRemise = (DeviseField)this.getEditor("REMISE_HT");
        totalRemise.setEditable(false);
        totalRemise.setEnabled(false);
    }

    @Override
    protected void addViews() {
        super.addViews();
        this.box.setSelected(true);
        this.addView(this.box, "PARTIAL", (Object)"required");
        DeviseField totalHT = (DeviseField)this.getEditor("T_HT");
        DeviseField totalService = (DeviseField)this.getEditor("T_SERVICE");
        DeviseField totalSupply = (DeviseField)this.getEditor("T_HA");
        DeviseField totalDevise = (DeviseField)this.getEditor("T_DEVISE");
        JTextField totalWeight = (JTextField)this.getEditor("T_POIDS");
        final DeviseField totalTTC = (DeviseField)this.getEditor("T_TTC");
        DeviseField totalTVA = (DeviseField)this.getEditor("T_TVA");
        DeviseField totalEco = (DeviseField)this.getEditor("T_ECO_CONTRIBUTION");
        DeviseField totalRemise = (DeviseField)this.getEditor("REMISE_HT");
        totalRemise.setEditable(false);
        totalRemise.setEnabled(false);
        DeviseField totalPORT = (DeviseField)this.getEditor("PORT_HT");
        this.addView(totalPORT, "PORT_HT");
        this.addView(totalTVA, "T_TVA");
        this.addView(totalTTC, "T_TTC");
        this.addView(totalEco, "T_ECO_CONTRIBUTION");
        this.addView(totalWeight, "T_POIDS");
        this.addView(totalDevise, "T_DEVISE");
        this.addView(totalSupply, "T_HA");
        this.addView(totalService, "T_SERVICE");
        this.addView(totalHT, "T_HT");
        final DeviseField fieldNet = new DeviseField();
        this.addView(fieldNet, "NET_A_PAYER");
        totalTTC.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                fieldNet.setText(totalTTC.getText());
            }
        });
        final SQLRequestComboBox sqlRequestComboBoxAdr = (SQLRequestComboBox)this.getEditor("ID_ADRESSE");
        final SQLRequestComboBox sqlRequestComboBoxAdrL = (SQLRequestComboBox)this.getEditor("ID_ADRESSE_LIVRAISON");
        final SQLRequestComboBox sqlRequestComboBox = (SQLRequestComboBox)this.getEditor("sales.invoice.customer");
        final FactureSituationItemTable table = (FactureSituationItemTable)this.getEditor("sales.invoice.partial.items.list");
        final TotalPanel total = (TotalPanel)this.getEditor("sales.invoice.partial.total.amount");
        sqlRequestComboBox.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int idModeRegl;
                int wantedID = sqlRequestComboBox.getWantedID();
                if (wantedID != -1 && wantedID >= 0) {
                    sqlRequestComboBoxAdr.getRequest().setWhere(new Where((FieldRef)VenteFactureSituationSQLComponent.this.getTable().getTable("ADRESSE").getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)VenteFactureSituationSQLComponent.this.getTable().getTable("ADRESSE").getField("TYPE"), "=", (Object)AdresseType.Invoice.getId())));
                    sqlRequestComboBoxAdrL.getRequest().setWhere(new Where((FieldRef)VenteFactureSituationSQLComponent.this.getTable().getTable("ADRESSE").getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)VenteFactureSituationSQLComponent.this.getTable().getTable("ADRESSE").getField("TYPE"), "=", (Object)AdresseType.Delivery.getId())));
                    SQLRow rowCli = VenteFactureSituationSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                    if (rowCli.getObject("ID_CATEGORIE_COMPTABLE") != null && !rowCli.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
                        total.setCategorieComptable(rowCli.getForeign("ID_CATEGORIE_COMPTABLE"));
                        table.setRowCatComptable(rowCli.getForeign("ID_CATEGORIE_COMPTABLE"));
                    } else {
                        total.setCategorieComptable(null);
                        table.setRowCatComptable(null);
                    }
                } else {
                    sqlRequestComboBoxAdr.getRequest().setWhere(Where.FALSE);
                    sqlRequestComboBoxAdrL.getRequest().setWhere(Where.FALSE);
                    total.setCategorieComptable(null);
                    table.setRowCatComptable(null);
                }
                SQLElement sqleltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                SQLRow client = sqlRequestComboBox.getSelectedRow();
                if (client != null && !client.isUndefined() && (idModeRegl = client.getInt("ID_MODE_REGLEMENT")) > 1) {
                    SQLRow rowModeRegl = sqleltModeRegl.getTable().getRow(idModeRegl);
                    SQLRowValues rowValsModeRegl = rowModeRegl.createUpdateRow();
                    rowValsModeRegl.clearPrimaryKeys();
                    ((ElementSQLObject)VenteFactureSituationSQLComponent.this.getEditor("ID_MODE_REGLEMENT")).setValue(rowValsModeRegl);
                }
            }
        });
        sqlRequestComboBox.setEnabled(false);
        final AcompteField acompteField = (AcompteField)this.getEditor("sales.invoice.partial.amount");
        this.listenerAcompteField = new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                if (!VenteFactureSituationSQLComponent.this.isFilling()) {
                    Acompte a = acompteField.getValue();
                    table.calculPourcentage(a, AbstractVenteArticleItemTable.TypeCalcul.CALCUL_FACTURABLE);
                }
            }
        };
        acompteField.getDocument().addDocumentListener(this.listenerAcompteField);
        this.listenerTable = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                acompteField.getDocument().removeDocumentListener(VenteFactureSituationSQLComponent.this.listenerAcompteField);
                if (e.getColumn() == table.getModel().getColumnForField("POURCENT_FACTURABLE")) {
                    Acompte a = new Acompte(null, table.getTotalHT(AbstractVenteArticleItemTable.TypeCalcul.CALCUL_MONTANT_TOTAL));
                    acompteField.setValue(a);
                }
                acompteField.getDocument().addDocumentListener(VenteFactureSituationSQLComponent.this.listenerAcompteField);
            }
        };
        table.getRowValuesTable().getModel().addTableModelListener(this.listenerTable);
        total.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                acompteField.setTotal(new BigDecimal(total.getTotalHT()).movePointLeft(2));
            }
        });
    }

    @Override
    public JComponent getLabel(String id) {
        if (id.equals("sales.invoice.partial.amount")) {
            JLabel jLabel = new JLabel("Montant HT (ou %) \u00e0 facturer");
            jLabel.setHorizontalAlignment(4);
            return jLabel;
        }
        if (id.equals("panel.oo")) {
            return new JLabel();
        }
        if (id.equals("sales.invoice.partial.total.amount")) {
            return new JLabel();
        }
        return super.getLabel(id);
    }

    @Override
    public JComponent createEditor(String id) {
        if (id.equals("sales.invoice.number")) {
            this.numberField = new JUniqueTextField(20){

                @Override
                public String getAutoRefreshNumber() {
                    if (VenteFactureSituationSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                        return NumerotationAutoSQLElement.getNextNumero(VenteFactureSituationSQLComponent.this.getElement().getClass(), ((JDate)VenteFactureSituationSQLComponent.this.getEditor("DATE")).getDate());
                    }
                    return null;
                }
            };
            return this.numberField;
        }
        if (id.equals("panel.oo")) {
            this.panelOO = new PanelOOSQLComponent(this);
            return this.panelOO;
        }
        if (id.equals("INFOS")) {
            ITextArea jTextArea = new ITextArea();
            jTextArea.setFont(new JLabel().getFont());
            return jTextArea;
        }
        if (id.equals("sales.invoice.partial.items.list")) {
            return new FactureSituationItemTable();
        }
        if (id.equals("DATE")) {
            return new JDate(true);
        }
        if (id.equals("T_POIDS")) {
            return new JTextField();
        }
        if (id.equals("sales.invoice.partial.total.amount")) {
            AbstractArticleItemTable items = (AbstractArticleItemTable)this.getEditor("sales.invoice.partial.items.list");
            int i = 0;
            while (i < items.getRowValuesTable().getColumnModel().getColumnCount(false)) {
                SQLTableElement sqlTableElementAt = items.getRowValuesTable().getRowValuesTableModel().getSQLTableElementAt(i);
                if (sqlTableElementAt.getField() != null && (sqlTableElementAt.getField().getName().equalsIgnoreCase("ID_STYLE") || sqlTableElementAt.getField().getName().equalsIgnoreCase("POURCENT_FACTURABLE") || sqlTableElementAt.getField().getName().equalsIgnoreCase("ID_TAXE"))) {
                    sqlTableElementAt.setEditable(true);
                } else {
                    sqlTableElementAt.setEditable(false);
                }
                ++i;
            }
            DeviseField totalHT = (DeviseField)this.getEditor("T_HT");
            DeviseField totalEco = (DeviseField)this.getEditor("T_ECO_CONTRIBUTION");
            DeviseField totalService = (DeviseField)this.getEditor("T_SERVICE");
            DeviseField totalSupply = (DeviseField)this.getEditor("T_HA");
            DeviseField totalDevise = (DeviseField)this.getEditor("T_DEVISE");
            JTextField totalWeight = (JTextField)this.getEditor("T_POIDS");
            DeviseField totalTTC = (DeviseField)this.getEditor("T_TTC");
            DeviseField totalTVA = (DeviseField)this.getEditor("T_TVA");
            DeviseField totalRemise = (DeviseField)this.getEditor("REMISE_HT");
            totalRemise.setEditable(false);
            totalRemise.setEnabled(false);
            AcompteField acompte = (AcompteField)this.getEditor("sales.invoice.partial.amount");
            DeviseField totalPORT = (DeviseField)this.getEditor("PORT_HT");
            SQLRequestComboBox taxePort = (SQLRequestComboBox)this.getEditor("ID_TAXE_PORT");
            return new TotalPanel(items, totalEco, totalHT, totalTVA, totalTTC, totalPORT, totalRemise, totalService, totalSupply, totalDevise, totalWeight, null, taxePort, acompte);
        }
        if (id.startsWith("T_")) {
            return new DeviseField();
        }
        if (id.equals("REMISE_HT") || id.equals("PORT_HT")) {
            DeviseField fieldD = new DeviseField();
            fieldD.setEditable(false);
            fieldD.setEnabled(false);
            return fieldD;
        }
        if (id.startsWith("ID_ADRESSE")) {
            ElementComboBox comboAdrF = new ElementComboBox();
            comboAdrF.setButtonsVisible(false);
            SQLElement adrElement = this.getElement().getForeignElement("ID_ADRESSE");
            comboAdrF.init(adrElement, adrElement.getComboRequest(true));
            comboAdrF.getRequest().setWhere(Where.FALSE);
            return comboAdrF;
        }
        if (id.equals("sales.invoice.partial.amount")) {
            return new AcompteField();
        }
        return super.createEditor(id);
    }

    @Override
    public int insert(SQLRow order) {
        String num;
        int idSaisieVF = -1;
        int attempt = 0;
        if (!this.numberField.checkValidation(false)) {
            while (attempt < JUniqueTextField.RETRY_COUNT) {
                num = NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), ((JDate)this.getEditor("DATE")).getDate());
                this.numberField.setText(num);
                ++attempt;
                if (this.numberField.checkValidation(false)) {
                    System.err.println("ATEMPT " + attempt + " SUCCESS WITH NUMERO " + num);
                    break;
                }
                try {
                    Thread.sleep(JUniqueTextField.SLEEP_WAIT_MS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        num = this.numberField.getText();
        if (attempt == JUniqueTextField.RETRY_COUNT) {
            idSaisieVF = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de facture existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        } else {
            idSaisieVF = super.insert(order);
            SQLRow rowFacture = this.getTable().getRow(idSaisieVF);
            if (NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, rowFacture.getDate("DATE").getTime()).equalsIgnoreCase(this.numberField.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                String labelNumberFor = NumerotationAutoSQLElement.getLabelNumberFor(SaisieVenteFactureSQLElement.class);
                int val = this.tableNum.getRow(2).getInt(labelNumberFor);
                rowVals.put(labelNumberFor, (Object)(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            ((AbstractArticleItemTable)this.getEditor("sales.invoice.partial.items.list")).updateField("ID_SAISIE_VENTE_FACTURE", idSaisieVF);
            new GenerationMvtSaisieVenteFacture(idSaisieVF);
            try {
                VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowFacture);
                sheet.createDocument();
                sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true, this.getElement(), rowFacture);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Une erreur est survenue lors de la cr\u00e9ation du document.", e);
            }
            if (attempt > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Le num\u00e9ro a \u00e9t\u00e9 actualis\u00e9 en " + num);
                    }
                });
            }
        }
        return idSaisieVF;
    }

    @Override
    public void update() {
        int id = this.getSelectedID();
        super.update();
        SQLRow rowFacture = this.getTable().getRow(id);
        ((AbstractArticleItemTable)this.getEditor("sales.invoice.partial.items.list")).updateField("ID_SAISIE_VENTE_FACTURE", id);
        int idMvt = rowFacture.getInt("ID_MOUVEMENT");
        System.err.println("Archivage des fils");
        EcritureSQLElement eltEcr = (EcritureSQLElement)this.getDirectory().getElement("ECRITURE");
        eltEcr.archiveMouvementProfondeur(idMvt, false);
        new GenerationMvtSaisieVenteFacture(id);
        try {
            VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowFacture);
            sheet.createDocument();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true, this.getElement(), rowFacture);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Une erreur est survenue lors de la cr\u00e9ation du document.", e);
        }
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date()));
        rowVals.put("PARTIAL", Boolean.TRUE);
        return rowVals;
    }

    @Override
    public Component addView(JComponent comp, String id) {
        if (id.equals("sales.invoice.partial.amount")) {
            return super.addView(new AcompteRowItemView((AcompteField)comp), "MONTANT_FACTURABLE,POURCENT_FACTURABLE", (Object)"required");
        }
        return super.addView(comp, id);
    }
}

