/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ListeDesEncaissementsAction
extends CreateFrameAbstractAction {
    public ListeDesEncaissementsAction() {
        this.putValue("Name", "Liste des encaissements");
    }

    public JFrame createFrame() {
        SQLElement elementEchClient = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
        ListeAddPanel panel = new ListeAddPanel(elementEchClient, new IListe(elementEchClient.getTableSource(true))){

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonEffacer) {
                    List<SQLRowValues> rowValsSel = this.getListe().getSelectedRows();
                    if (rowValsSel.size() == 1 && rowValsSel.get(0).getBoolean("ACOMPTE").booleanValue() || this.isEncaissementEditable(rowValsSel, "effacer")) {
                        super.handleAction(source, evt);
                    }
                } else if (source == this.buttonModifier) {
                    List<SQLRowValues> rowValsSel = this.getListe().getSelectedRows();
                    if (this.isEncaissementEditable(rowValsSel, "supprimer")) {
                        super.handleAction(source, evt);
                    }
                } else {
                    super.handleAction(source, evt);
                }
            }

            private boolean isEncaissementEditable(List<SQLRowValues> rowValsSel, String action) {
                for (SQLRowValues sqlRowValues : rowValsSel) {
                    SQLRow asRow = sqlRowValues.asRow();
                    Collection rowItems = asRow.getReferentRows(sqlRowValues.getTable().getTable("ENCAISSER_MONTANT_ELEMENT"));
                    for (SQLRowAccessor sqlRowValues2 : rowItems) {
                        if (!sqlRowValues2.isForeignEmpty("ID_ECHEANCE_CLIENT")) continue;
                        JOptionPane.showMessageDialog(null, "Impossible de " + action + " un encaissement qui ne vient pas d'une \u00e9ch\u00e9ance");
                        return false;
                    }
                    SQLRowAccessor rowAcMvt = asRow.getNonEmptyForeign("ID_MOUVEMENT");
                    if (rowAcMvt == null) continue;
                    Collection<? extends SQLRowAccessor> rowItemsEcr = rowAcMvt.getReferentRows(rowAcMvt.getTable().getTable("ECRITURE").getField("ID_MOUVEMENT"));
                    for (SQLRowAccessor sQLRowAccessor : rowItemsEcr) {
                        if (!sQLRowAccessor.getBoolean("VALIDE").booleanValue()) continue;
                        JOptionPane.showMessageDialog(null, "Impossible de " + action + " un encaissement dont les \u00e9critures sont valid\u00e9es.");
                        return false;
                    }
                }
                return true;
            }
        };
        panel.setAddVisible(false);
        IListFrame frame = new IListFrame(panel);
        ArrayList<SQLField> fields = new ArrayList<SQLField>(2);
        fields.add(elementEchClient.getTable().getField("MONTANT"));
        IListTotalPanel totalPanel = new IListTotalPanel(frame.getPanel().getListe(), fields, "Total Global");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridy = 4;
        frame.getPanel().add((Component)totalPanel, c);
        IListFilterDatePanel datePanel = new IListFilterDatePanel(frame.getPanel().getListe(), elementEchClient.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        ++c.gridy;
        c.anchor = 10;
        frame.getPanel().add((Component)datePanel, c);
        return frame;
    }
}

