/*
 * Decompiled with CFR 0.152.
 */
package ds.desktop.notify;

import ds.desktop.notify.DesktopNotify;
import ds.desktop.notify.NotifyTheme;
import java.awt.Image;
import java.awt.event.ActionListener;

public class NotificationBuilder {
    private String title;
    private String message;
    private Image icon;
    private int type = 0;
    private long timeOut = 0L;
    private ActionListener action;
    private NotifyTheme theme;

    public NotificationBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public NotificationBuilder setMessage(String message) {
        this.message = message;
        return this;
    }

    public NotificationBuilder setIcon(Image icon) {
        this.icon = icon;
        return this;
    }

    public NotificationBuilder setType(int type) {
        this.type = type;
        return this;
    }

    public NotificationBuilder setTimeOut(long timeOut) {
        this.timeOut = timeOut;
        return this;
    }

    public NotificationBuilder setAction(ActionListener action) {
        this.action = action;
        return this;
    }

    public NotificationBuilder setTheme(NotifyTheme theme) {
        this.theme = theme;
        return this;
    }

    public DesktopNotify build() {
        if (this.title == null && this.message == null) {
            throw new IllegalStateException("The notification lacks of any text to show!");
        }
        DesktopNotify pane = new DesktopNotify(this.title, this.message, this.type, this.icon);
        pane.setTimeout(this.timeOut);
        pane.setAction(this.action);
        pane.setTheme(this.theme);
        return pane;
    }

    public void reset() {
        this.title = null;
        this.message = null;
        this.icon = null;
        this.type = 0;
        this.timeOut = 0L;
        this.action = null;
        this.theme = null;
    }

    public DesktopNotify buildAndReset() {
        DesktopNotify pane = this.build();
        this.reset();
        return pane;
    }
}

