/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.tools;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.PropertyPermission;
import org.openconcerto.utils.protocol.Helper;
import org.openconcerto.utils.tools.SimpleURLClassLoader;

public final class Outer {
    private final String className;

    public static void main(String[] args) throws Exception {
        String className = args[0];
        String fieldName = args[1];
        Helper.register();
        final ClassLoader mainLoader = Outer.class.getClassLoader();
        Policy.setPolicy(new Policy(){

            @Override
            public boolean implies(ProtectionDomain domain, Permission permission) {
                if (domain != null && domain.getClassLoader() == mainLoader) {
                    return true;
                }
                return super.implies(domain, permission);
            }
        });
        System.setSecurityManager(new SecurityManager());
        Permissions innerPerms = new Permissions();
        ((PermissionCollection)innerPerms).add(new RuntimePermission("accessDeclaredMembers"));
        if (Boolean.getBoolean("property.read")) {
            ((PermissionCollection)innerPerms).add(new PropertyPermission("*", "read"));
        }
        innerPerms.setReadOnly();
        System.out.print(new Outer(className).getFieldValue(innerPerms, fieldName));
    }

    public Outer(String className) {
        this.className = className;
    }

    public Object getFieldValue(final PermissionCollection perms, String fieldName) throws ClassNotFoundException, ReflectiveOperationException {
        if (!this.getClass().getResource(String.valueOf(this.getClass().getSimpleName()) + ".class").toExternalForm().startsWith("jar:file:")) {
            throw new IllegalStateException("Class not loaded from a jar");
        }
        SimpleURLClassLoader loader = new SimpleURLClassLoader(new SimpleURLClassLoader.URLCollector().addJar(this.getClass().getResource("/inner.jar"))){

            @Override
            protected PermissionCollection getPermissions(CodeSource codesource) {
                return perms;
            }
        };
        Class<?> loadedClass = loader.loadClass(this.className);
        return loadedClass.getDeclaredField(fieldName).get(null);
    }
}

