/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.jdom2.Document;
import org.jdom2.Element;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class ColumnsSpec
implements Externalizable,
Transferable {
    private String id;
    private List<ColumnSpec> columns = new ArrayList<ColumnSpec>();
    private List<String> possibleColumnIds = new ArrayList<String>();
    private List<String> sortedIds = new ArrayList<String>();
    private int fixedColumns;
    private Boolean adaptWidth = false;
    private Boolean allowMove = false;
    private Boolean allowResize = false;

    public ColumnsSpec() {
    }

    public ColumnsSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public ColumnsSpec(String id, List<ColumnSpec> columns, List<String> possibleColumnIds, List<String> sortedIds) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("null id");
        }
        this.id = id;
        if (columns == null) {
            throw new IllegalArgumentException("null columns");
        }
        this.columns = columns;
        if (possibleColumnIds == null) {
            throw new IllegalArgumentException("null possible column ids");
        }
        this.possibleColumnIds = possibleColumnIds;
        this.sortedIds = sortedIds;
    }

    public final String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPossibleColumnIds(List<String> possibleColumnIds) {
        this.possibleColumnIds = possibleColumnIds;
    }

    public final List<String> getPossibleColumnIds() {
        return this.possibleColumnIds;
    }

    public void setSortedIds(List<String> sortedIds) {
        this.sortedIds = sortedIds;
    }

    public final List<String> getSortedIds() {
        return this.sortedIds;
    }

    public final int getFixedColumns() {
        return this.fixedColumns;
    }

    public void setFixedColumns(int fixedColumns) {
        this.fixedColumns = fixedColumns;
    }

    public final int getColumnCount() {
        return this.columns.size();
    }

    public final ColumnSpec getColumn(int i) {
        return this.columns.get(i);
    }

    public final ColumnSpec setColumn(int i, ColumnSpec column) {
        return this.columns.set(i, column);
    }

    public final Boolean isAdaptWidth() {
        return this.adaptWidth;
    }

    public final void setAdaptWidth(boolean adaptWidth) {
        this.adaptWidth = adaptWidth;
    }

    public final Boolean isAllowMove() {
        return this.allowMove;
    }

    public final void setAllowMove(boolean allowMove) {
        this.allowMove = allowMove;
    }

    public final Boolean isAllowResize() {
        return this.allowResize;
    }

    public final void setAllowResize(boolean allowResize) {
        this.allowResize = allowResize;
    }

    public List<String> getColumnsIds() {
        ArrayList<String> result = new ArrayList<String>(this.columns.size());
        for (ColumnSpec c : this.columns) {
            result.add(c.getId());
        }
        return result;
    }

    public void setColumns(List<ColumnSpec> columns) {
        this.columns = columns;
    }

    public List<ColumnSpec> getColumns() {
        return this.columns;
    }

    public final boolean setUserPrefs(Document columnsPrefs) {
        if (columnsPrefs != null) {
            Element rootElement = columnsPrefs.getRootElement();
            if (!rootElement.getName().equals("list")) {
                throw new IllegalArgumentException("invalid xml, roots node list expected but " + rootElement.getName() + " found");
            }
            List<Element> xmlColumns = rootElement.getChildren();
            int columnsCount = this.columns.size();
            if (xmlColumns.size() == columnsCount) {
                int i = 0;
                while (i < columnsCount) {
                    ColumnSpec columnSpec = this.columns.get(i);
                    String columnId = columnSpec.getId();
                    boolean find = false;
                    int j = 0;
                    while (j < columnsCount) {
                        Element xmlColumn = xmlColumns.get(j);
                        String xmlColumnId = xmlColumn.getAttribute("id").getValue();
                        if (xmlColumnId.equals(columnId)) {
                            if (!xmlColumn.getName().equals("column")) {
                                throw new IllegalArgumentException("ColumnSpec setPrefs - Invalid xml, element node column expected but " + xmlColumn.getName() + " found");
                            }
                            if (xmlColumn.getAttribute("width") == null) {
                                throw new IllegalArgumentException("ColumnSpec setPrefs - Invalid column node for " + columnId + " : missing width");
                            }
                            double width = Double.parseDouble(xmlColumn.getAttribute("width").getValue());
                            if (width <= columnSpec.getMaxWidth() && width >= columnSpec.getMinWidth() && this.allowResize.booleanValue()) {
                                columnSpec.setWidth(width);
                            }
                            if (i != j && this.allowMove.booleanValue()) {
                                ColumnSpec swap = this.columns.get(i);
                                this.columns.set(i, this.columns.get(j));
                                this.columns.set(j, swap);
                                --i;
                            }
                            find = true;
                            break;
                        }
                        ++j;
                    }
                    if (!find) {
                        return false;
                    }
                    ++i;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeInt(this.fixedColumns);
        out.writeObject(this.columns);
        out.writeObject(this.possibleColumnIds);
        out.writeObject(this.sortedIds);
        out.writeBoolean(this.allowMove);
        out.writeBoolean(this.allowResize);
        out.writeBoolean(this.adaptWidth);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.fixedColumns = in.readInt();
        this.columns = CollectionUtils.castList((List)in.readObject(), ColumnSpec.class);
        this.possibleColumnIds = CollectionUtils.castList((List)in.readObject(), String.class);
        this.sortedIds = CollectionUtils.castList((List)in.readObject(), String.class);
        this.allowMove = in.readBoolean();
        this.allowResize = in.readBoolean();
        this.adaptWidth = in.readBoolean();
    }

    public final List<Object> getDefaultValues() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (ColumnSpec column : this.columns) {
            Object v = column.getDefaultValue();
            l.add(v);
        }
        return l;
    }

    public final ColumnSpec getColumn(String id) {
        for (ColumnSpec c : this.columns) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    public final ColumnSpec getColumnWithEditor(String id) {
        for (ColumnSpec c : this.columns) {
            LightUIElement editor = c.getEditor();
            if (editor == null || !c.getEditor().getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "ColumnsSpec");
        result.put("id", this.id);
        result.put("fixed-columns", this.fixedColumns);
        if (this.sortedIds != null && this.sortedIds.size() > 0) {
            result.put("sorted-ids", this.sortedIds);
        }
        if (this.possibleColumnIds != null && this.possibleColumnIds.size() > 0) {
            result.put("possible-column-ids", this.possibleColumnIds);
        }
        if (this.columns != null && this.columns.size() > 0) {
            result.put("columns", JSONConverter.getJSON(this.columns));
        }
        if (this.adaptWidth.booleanValue()) {
            result.put("adapt-width", JSONConverter.getJSON(true));
        }
        if (this.allowMove.booleanValue()) {
            result.put("allow-move", JSONConverter.getJSON(true));
        }
        if (this.allowResize.booleanValue()) {
            result.put("allow-resize", JSONConverter.getJSON(true));
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.id = JSONConverter.getParameterFromJSON(json, "id", String.class);
        this.fixedColumns = JSONConverter.getParameterFromJSON(json, "fixed-columns", Integer.class);
        this.adaptWidth = JSONConverter.getParameterFromJSON(json, "adapt-width", Boolean.class, false);
        this.allowMove = JSONConverter.getParameterFromJSON(json, "allow-move", Boolean.class, false);
        this.allowResize = JSONConverter.getParameterFromJSON(json, "allow-resize", Boolean.class, false);
        this.sortedIds = CollectionUtils.castList(JSONConverter.getParameterFromJSON(json, "sorted-ids", List.class, new ArrayList()), String.class);
        this.possibleColumnIds = CollectionUtils.castList(JSONConverter.getParameterFromJSON(json, "possible-column-ids", List.class, new ArrayList()), String.class);
        List<JSONObject> jsonColumns = CollectionUtils.castList(JSONConverter.getParameterFromJSON(json, "columns", JSONArray.class, null), JSONObject.class);
        if (jsonColumns != null) {
            for (JSONObject jsonColumn : jsonColumns) {
                this.columns.add(new ColumnSpec(jsonColumn));
            }
        }
    }
}

