/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.utils.Tuple2;

public class JoinSQLElement
extends ConfSQLElement {
    private final Tuple2.List2<Link> links;
    private final Path p;

    public static SQLTableBuilder createBuilder(SQLTable ownerT, SQLTable ownedT) {
        return new SQLTableBuilder(ownerT, ownedT);
    }

    public static Builder<?> createBuilder(SQLCreateTable ownerT, SQLCreateTable ownedT) {
        return new CreateTableBuilder(ownerT, ownedT);
    }

    public static final String getDefaultFKName(String tableName) {
        return "ID_" + tableName;
    }

    public static final String getDefaultTableName(String owner, String owned) {
        return String.valueOf(owner) + '_' + owned;
    }

    public JoinSQLElement(SQLTable table, String ... fieldsToOwner) {
        this(table, table.getDBSystemRoot().getGraph().getForeignLink(table, Arrays.asList(fieldsToOwner)));
    }

    public JoinSQLElement(SQLTable table, Link linkToOwner) {
        super(table);
        this.links = this.checkTable(linkToOwner);
        this.p = this.createPath();
    }

    private Tuple2.List2<Link> checkTable(Link linkToOwner) {
        ArrayList<Link> fks = new ArrayList<Link>(this.getTable().getDBSystemRoot().getGraph().getForeignLinks(this.getTable()));
        if (fks.size() != 2) {
            throw new IllegalStateException("Not 2 foreign keys : " + fks);
        }
        int index = fks.indexOf(linkToOwner);
        if (index < 0) {
            throw new IllegalArgumentException("Link " + linkToOwner + " not in " + fks);
        }
        return new Tuple2.List2<Link>(linkToOwner, index == 0 ? (Link)fks.get(1) : (Link)fks.get(0));
    }

    final Link getLinkToOwner() {
        return (Link)this.links.get0();
    }

    public final SQLTable getOwnerTable() {
        return (SQLTable)this.getLinkToOwner().getTarget();
    }

    public final Step getStepFromOwner() {
        return this.getPathFromOwner().getStep(0);
    }

    final Link getLinkToOwned() {
        return (Link)this.links.get1();
    }

    public final SQLTable getOwnedTable() {
        return (SQLTable)this.getLinkToOwned().getTarget();
    }

    public final Step getStepToOwned() {
        return this.getPathFromOwner().getStep(1);
    }

    final Link getOppositeLink(Link l) {
        Link l1 = (Link)this.links.get0();
        Link l2 = (Link)this.links.get1();
        if (l1.equals(l)) {
            return l2;
        }
        if (l2.equals(l)) {
            return l1;
        }
        throw new IllegalArgumentException(l + " isn't in " + this.links);
    }

    private Path createPath() {
        return ((PathBuilder)((PathBuilder)new PathBuilder(this.getOwnerTable()).add(this.getLinkToOwner(), Link.Direction.REFERENT)).add(this.getLinkToOwned(), Link.Direction.FOREIGN)).build();
    }

    public final Path getPathFromOwner() {
        return this.p;
    }

    public final SQLElementLink getJoinLink() {
        return this.getDirectory().getElement(this.getOwnerTable()).getOwnedLinks().getByPath(this.getPathFromOwner());
    }

    @Override
    public final boolean isPrivate() {
        return false;
    }

    @Override
    protected final String getParentFFName() {
        return super.getParentFFName();
    }

    @Override
    protected final void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
    }

    @Override
    public final SQLComponent createComponent() {
        return null;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String ownerFK;
        private String ownedFK;
        private String tableName;

        protected Builder() {
            assert (this.thisAsT() == this);
        }

        protected abstract T thisAsT();

        protected abstract DBRoot getOwnerRoot();

        protected abstract String getOwnerTableName();

        protected abstract String getOwnedTableName();

        public final T setTableName(String tableName) {
            this.tableName = tableName == null ? JoinSQLElement.getDefaultTableName(this.getOwnerTableName(), this.getOwnedTableName()) : tableName;
            return this.thisAsT();
        }

        public final String getTableName() {
            assert (this.tableName != null) : "setTableName(null) wasn't called";
            return this.tableName;
        }

        public final T setOwnerFK(String ownerFK) {
            if (ownerFK != null && ownerFK.equals(this.ownedFK)) {
                throw new IllegalArgumentException("Same name : " + ownerFK);
            }
            this.ownerFK = ownerFK;
            return this.thisAsT();
        }

        public final T setOwnedFK(String ownedFK) {
            if (ownedFK != null && ownedFK.equals(this.ownerFK)) {
                throw new IllegalArgumentException("Same name : " + ownedFK);
            }
            this.ownedFK = ownedFK;
            return this.thisAsT();
        }

        public final Tuple2.List2<String> getFKs() {
            String ownedFK;
            String ownerFK = this.ownerFK == null ? JoinSQLElement.getDefaultFKName(this.getOwnerTableName()) : this.ownerFK;
            String string = ownedFK = this.ownedFK == null ? JoinSQLElement.getDefaultFKName(this.getOwnedTableName()) : this.ownedFK;
            if (ownerFK.equals(ownedFK)) {
                ownerFK = String.valueOf(ownerFK) + "_OWNER";
                ownedFK = String.valueOf(ownedFK) + "_OWNED";
            }
            return new Tuple2.List2<String>(ownerFK, ownedFK);
        }

        protected abstract void addForeignColumns(SQLCreateTable var1, String var2, String var3);

        protected final SQLCreateTable setupCreateTable(SQLCreateTable res) {
            Tuple2.List2<String> fks = this.getFKs();
            String toOwner = (String)fks.get0();
            res.setOrderConstraintFields(Collections.singleton(toOwner));
            this.addForeignColumns(res, toOwner, (String)fks.get1());
            res.addVarCharColumn("LABEL", 100);
            return res;
        }

        public final SQLCreateTable getCreateTable() {
            return this.setupCreateTable(new SQLCreateTable(this.getOwnerRoot(), this.getTableName()));
        }

        public final SQLTable getJoinTable() {
            return this.getOwnerRoot().getTable(this.getTableName());
        }

        public final JoinSQLElement createElement() {
            return new JoinSQLElement(this.getJoinTable(), (String)this.getFKs().get0());
        }

        public final SQLTable buildTable() throws SQLException {
            return this.getOwnerRoot().createTable(this.getCreateTable());
        }

        public final JoinSQLElement buildElement() throws SQLException {
            SQLTable joinT = this.buildTable();
            JoinSQLElement res = this.createElement();
            assert (res.getTable() == joinT);
            return res;
        }
    }

    private static final class CreateTableBuilder
    extends Builder<CreateTableBuilder> {
        private final SQLCreateTable ownerT;
        private final SQLCreateTable ownedT;

        private CreateTableBuilder(SQLCreateTable ownerT, SQLCreateTable ownedT) {
            this.ownerT = ownerT;
            this.ownedT = ownedT;
            this.setTableName(null);
        }

        @Override
        protected CreateTableBuilder thisAsT() {
            return this;
        }

        @Override
        protected String getOwnedTableName() {
            return this.ownedT.getName();
        }

        @Override
        protected String getOwnerTableName() {
            return this.ownerT.getName();
        }

        @Override
        protected DBRoot getOwnerRoot() {
            return this.ownerT.getRoot();
        }

        @Override
        protected void addForeignColumns(SQLCreateTable res, String toOwnerFK, String toOwnedFK) {
            res.addForeignColumn(toOwnerFK, this.ownerT);
            res.addForeignColumn(toOwnedFK, this.ownedT);
        }
    }

    public static final class SQLTableBuilder
    extends Builder<SQLTableBuilder> {
        private final SQLTable ownerT;
        private final SQLTable ownedT;

        private SQLTableBuilder(SQLTable ownerT, SQLTable ownedT) {
            this.ownerT = ownerT;
            this.ownedT = ownedT;
            this.setTableName(null);
        }

        @Override
        protected SQLTableBuilder thisAsT() {
            return this;
        }

        @Override
        protected String getOwnedTableName() {
            return this.ownedT.getName();
        }

        @Override
        protected String getOwnerTableName() {
            return this.ownerT.getName();
        }

        @Override
        protected DBRoot getOwnerRoot() {
            return this.ownerT.getDBRoot();
        }

        @Override
        protected void addForeignColumns(SQLCreateTable res, String toOwnerFK, String toOwnedFK) {
            res.addForeignColumn(toOwnerFK, this.ownerT);
            res.addForeignColumn(toOwnedFK, this.ownedT);
        }
    }
}

