/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.sql.SQLException;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;

public class DeletePrivateOrphans
extends Changer<SQLTable> {
    private boolean deleteAll;

    public DeletePrivateOrphans(DBSystemRoot b) {
        super(b);
        this.setDeleteAll(true);
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        this.setDeleteAll(!Boolean.getBoolean("deleteOnlyUnarchived"));
    }

    public void setDeleteAll(boolean deleteArchived) {
        this.deleteAll = deleteArchived;
    }

    public boolean getDeleteAll() {
        return this.deleteAll;
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        this.getStream().print(t);
        if (Configuration.getInstance() == null || Configuration.getInstance().getDirectory() == null) {
            throw new IllegalStateException("no directory");
        }
        final SQLElement elem = Configuration.getInstance().getDirectory().getElement(t);
        if (elem == null) {
            this.getStream().println(" : no element");
            return;
        }
        if (!elem.isPrivate()) {
            this.getStream().println(" : not a private table");
            return;
        }
        if (elem.getParentLink() != null) {
            throw new IllegalStateException("Private with a parent : " + elem.getParentLink());
        }
        this.getStream().println("... ");
        SQLUtils.executeAtomic(this.getDS(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                SQLCreateTable createTable = new SQLCreateTable(t.getDBRoot(), "TO_DELETE_IDS");
                createTable.setTemporary(true);
                createTable.setPlain(true);
                String pkName = "ID";
                createTable.addColumn("ID", t.getKey());
                createTable.setPrimaryKey(t.getKey().getName());
                DeletePrivateOrphans.this.getDS().execute(createTable.asString());
                SQLName toDeleteIDsName = new SQLName(createTable.getName());
                SQLSelect selAllIDs = new SQLSelect(true).addSelect(t.getKey());
                selAllIDs.setExcludeUndefined(true);
                selAllIDs.setArchivedPolicy(DeletePrivateOrphans.this.getDeleteAll() ? SQLSelect.ArchiveMode.BOTH : SQLSelect.ArchiveMode.UNARCHIVED);
                DeletePrivateOrphans.this.getDS().execute("INSERT INTO " + toDeleteIDsName.quote() + " " + selAllIDs.asString());
                long total = DeletePrivateOrphans.this.getCount(toDeleteIDsName);
                if (total == 0L) {
                    DeletePrivateOrphans.this.getStream().println("nothing to delete");
                } else {
                    for (SQLElementLink privateLink : elem.getContainerLinks(true, false).getByPath().values()) {
                        if (!$assertionsDisabled && privateLink.getStepToChild().getTo() != t) {
                            throw new AssertionError();
                        }
                        SQLField pp = privateLink.getStepToChild().getSingleField();
                        DeletePrivateOrphans.this.getDS().execute(t.getBase().quote("DELETE from %i where %i in ( " + new SQLSelect(true).addSelect(pp).asString() + ")", toDeleteIDsName, "ID"));
                    }
                    DeletePrivateOrphans.this.getStream().println("archiving " + DeletePrivateOrphans.this.getCount(toDeleteIDsName) + " / " + total);
                    if (!DeletePrivateOrphans.this.isDryRun()) {
                        List ids = DeletePrivateOrphans.this.getDS().executeCol("select " + SQLBase.quoteIdentifier("ID") + " from " + toDeleteIDsName.quote());
                        elem.archiveIDs(ids);
                    }
                }
                DeletePrivateOrphans.this.getDS().execute("DROP TABLE " + toDeleteIDsName.quote());
                return null;
            }
        });
        this.getStream().println(t + " done");
    }

    private final long getCount(SQLName toDeleteIDsName) {
        return ((Number)this.getDS().execute("SELECT count(*) from " + toDeleteIDsName.quote(), new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false))).longValue();
    }
}

