/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.map.model.DatabaseAccessor;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class NXDatabaseAccessor
implements DatabaseAccessor {
    private final SQLTable tableVille;

    public NXDatabaseAccessor(ComptaPropsConfiguration comptaConf) {
        this.tableVille = comptaConf.getRootSociete().contains("VILLE") ? ComptaPropsConfiguration.getInstanceCompta().getRootSociete().getTable("VILLE") : comptaConf.getBase().getTable("VILLE");
    }

    @Override
    public List<Ville> read() {
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(this.tableVille);
        List l = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        ArrayList<Ville> lResult = new ArrayList<Ville>();
        for (SQLRow row : l) {
            String nom = row.getString("NOM");
            String cp = row.getString("CODE_POSTAL");
            long pop = ((Number)row.getObject("POPULATION")).longValue();
            long x = ((Number)row.getObject("X_LAMBERT")).longValue();
            long y = ((Number)row.getObject("Y_LAMBERT")).longValue();
            Ville v = new Ville(nom, pop, x, y, cp);
            lResult.add(v);
        }
        return lResult;
    }

    @Override
    public void store(Ville v) {
        SQLRowValues rowVals = new SQLRowValues(this.tableVille);
        rowVals.put("NOM", v.getName());
        rowVals.put("CODE_POSTAL", v.getCodepostal());
        rowVals.put("X_LAMBERT", v.getXLambert());
        rowVals.put("Y_LAMBERT", v.getYLambert());
        rowVals.put("POPULATION", v.getPopulation());
        try {
            rowVals.insert();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete(Ville v) {
        Where w = new Where((FieldRef)this.tableVille.getField("NOM"), "=", (Object)v.getName()).and(new Where((FieldRef)this.tableVille.getField("CODE_POSTAL"), "=", (Object)v.getCodepostal()));
        this.tableVille.getDBSystemRoot().getDataSource().execute("DELETE FROM " + this.tableVille.getSQLName().quote() + " WHERE " + w);
    }
}

