/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.utils.i18n.TranslationManager;

public class HeadlessGestion {
    private final ComptaPropsConfiguration comptaPropsConfiguration = ComptaPropsConfiguration.create();

    public HeadlessGestion setup(int userId, int companyId) {
        try {
            this.comptaPropsConfiguration.getUserManager().setCurrentUserID(userId);
            this.comptaPropsConfiguration.setUpSocieteDataBaseConnexion(companyId);
            this.comptaPropsConfiguration.getModuleManager().init();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to configure connection for userId: " + userId + " companyId: " + companyId, e);
        }
        return this;
    }

    public HeadlessGestion setupGlobalState(int userId, int companyId) {
        this.setGlobalState();
        this.setup(userId, companyId);
        return this;
    }

    public HeadlessGestion setGlobalState() {
        System.setProperty("java.awt.headless", "true");
        TranslationManager.addTranslationStreamFromClass(MainFrame.class);
        TranslationManager.createDefaultInstance();
        Configuration.setInstance(this.comptaPropsConfiguration);
        return this;
    }

    public ComptaPropsConfiguration getComptaPropsConfiguration() {
        return this.comptaPropsConfiguration;
    }

    public DBRoot getCompanyRoot() {
        return this.comptaPropsConfiguration.getRootSociete();
    }

    public DBRoot getCommonRoot() {
        return this.comptaPropsConfiguration.getRoot();
    }
}

