/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public class SocietePreferencePanel
extends DefaultPreferencePanel {
    private SQLComponent sc;
    private boolean valid = true;
    private String validText = "";

    public SocietePreferencePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        SQLTable tableSociete = Configuration.getInstance().getBase().getTable("SOCIETE_COMMON");
        this.sc = Configuration.getInstance().getDirectory().getElement(tableSociete).createDefaultComponent();
        this.sc.uiInit();
        this.sc.select(((ComptaPropsConfiguration)Configuration.getInstance()).getSocieteID());
        this.add((Component)this.sc, c);
        this.sc.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                SocietePreferencePanel.this.valid = newValue.isValid();
                SocietePreferencePanel.this.validText = newValue.getValidationText();
            }
        });
    }

    @Override
    public String getTitleName() {
        return "Soci\u00e9t\u00e9";
    }

    @Override
    public void storeValues() {
        if (this.valid) {
            this.sc.update();
        } else {
            final String t = this.validText == null ? "valeurs non valides" : this.validText;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(SocietePreferencePanel.this, t);
                }
            });
        }
    }

    @Override
    public void restoreToDefaults() {
    }
}

