/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ITransformer;

public class ExportSageEtendu
extends AbstractExport {
    private List<SQLRowValues> data;
    private Map<Integer, SQLRowValues> mapFacture = new HashMap<Integer, SQLRowValues>();
    private Map<Integer, SQLRowValues> mapAvoir = new HashMap<Integer, SQLRowValues>();

    public ExportSageEtendu(DBRoot rootSociete) {
        super(rootSociete, "Sage Etendu", ".xls");
    }

    @Override
    protected int fetchData(final Date from, final Date to, final SQLRow selectedJournal, final boolean onlyNew) {
        final SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableVF = tableEcriture.getTable("SAISIE_VENTE_FACTURE");
        SQLRowValues rowValsVF = new SQLRowValues(tableVF);
        rowValsVF.put("ID", null);
        rowValsVF.put("DATE", null);
        rowValsVF.put("NOM", null);
        rowValsVF.put("NUMERO", null);
        SQLRowValues rowValsMdr = rowValsVF.putRowValues("ID_MODE_REGLEMENT");
        rowValsMdr.putNulls(rowValsMdr.getTable().getFieldsName());
        rowValsMdr.putRowValues("ID_TYPE_REGLEMENT").putNulls("NOM");
        if (tableVF.contains("ID_ABONNEMENT")) {
            rowValsVF.putRowValues("ID_ABONNEMENT").putNulls("DATE_DEBUT_FACTURE", "DATE_FIN_FACTURE");
        }
        SQLRowValuesListFetcher fetcherVF = SQLRowValuesListFetcher.create(rowValsVF);
        List<SQLRowValues> resultVF = fetcherVF.fetch(new Where((FieldRef)tableVF.getField("DATE"), from, (Object)to));
        for (SQLRowValues sqlRowValues : resultVF) {
            this.mapFacture.put(sqlRowValues.getID(), sqlRowValues);
        }
        SQLTable tableAvoir = tableEcriture.getTable("AVOIR_CLIENT");
        SQLRowValues rowValsAvoir = new SQLRowValues(tableAvoir);
        rowValsAvoir.put("ID", null);
        rowValsAvoir.put("DATE", null);
        rowValsAvoir.put("NOM", null);
        rowValsAvoir.put("NUMERO", null);
        SQLRowValues rowValsMdrAvoir = rowValsAvoir.putRowValues("ID_MODE_REGLEMENT");
        rowValsMdrAvoir.putNulls(rowValsMdrAvoir.getTable().getFieldsName());
        rowValsMdrAvoir.putRowValues("ID_TYPE_REGLEMENT").putNulls("NOM");
        SQLRowValuesListFetcher fetcherAvoir = SQLRowValuesListFetcher.create(rowValsAvoir);
        List<SQLRowValues> resultAvoir = fetcherAvoir.fetch(new Where((FieldRef)tableAvoir.getField("DATE"), from, (Object)to));
        for (SQLRowValues sqlRowValues : resultAvoir) {
            this.mapAvoir.put(sqlRowValues.getID(), sqlRowValues);
        }
        final SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLRowValues rowValsFetch = new SQLRowValues(tableEcriture);
        rowValsFetch.putNulls("NOM", "DATE", "DEBIT", "CREDIT");
        if (tableEcriture.contains("CODE_CLIENT")) {
            rowValsFetch.put("CODE_CLIENT", null);
        }
        rowValsFetch.putRowValues("ID_MOUVEMENT").putNulls("NUMERO", "SOURCE", "IDSOURCE").putRowValues("ID_PIECE").put("NOM", null);
        rowValsFetch.putRowValues("ID_COMPTE_PCE").putNulls("NUMERO", "NOM");
        rowValsFetch.putRowValues("ID_JOURNAL").putNulls("CODE", "NOM");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsFetch);
        fetcher.addSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.setWhere(ExportSageEtendu.this.getWhere(from, to, selectedJournal, onlyNew));
                input.addFieldOrder(input.getAlias(tableEcriture).getField("ID_MOUVEMENT"));
                input.addFieldOrder(input.getAlias(tableCompte).getField("NUMERO"));
                return input;
            }
        }, 0);
        List<SQLRowValues> l = fetcher.fetch();
        this.data = l;
        return l == null ? 0 : l.size();
    }

    @Override
    protected void export(OutputStream bufOut) throws IOException {
        List<SQLRowValues> l = this.data;
        boolean containsCodeClient = this.getEcritureT().contains("CODE_CLIENT");
        int size = l.size();
        HSSFWorkbook workBook = new HSSFWorkbook();
        HSSFSheet sheet = workBook.createSheet("Ecritures");
        HSSFRow rowEntete = sheet.createRow(0);
        List<String> colName = Arrays.asList("Date d'\u00e9criture", "Code Journal", "Num\u00e9ro de facture", "R\u00e9f\u00e9rence", "Compte G\u00e9n\u00e9ral", "Compte Client", "Libell\u00e9 de l'\u00e9criture", "Date d'\u00e9ch\u00e9ance", "Mode de r\u00e8glement", "Montant d\u00e9biteur", "Montant Cr\u00e9diteur", "Date de d\u00e9but d'abonnement", "Date de fin d'abonnement");
        int colIndex = 0;
        for (String string : colName) {
            Cell cell = rowEntete.createCell(colIndex, CellType.STRING);
            cell.setCellValue(string);
            ++colIndex;
        }
        HSSFCellStyle cellStyle = workBook.createCellStyle();
        HSSFCreationHelper createHelper = workBook.getCreationHelper();
        cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("m/d/yy"));
        int i = 0;
        while (i < size) {
            SQLRowAccessor rowValsAbo;
            HSSFRow row = sheet.createRow(i + 1);
            SQLRowValues rowLine = l.get(i);
            Date d = rowLine.getDate("DATE").getTime();
            Cell cellDate = row.createCell(0);
            cellDate.setCellStyle((CellStyle)cellStyle);
            cellDate.setCellValue(d);
            SQLRowAccessor rowJrnl = rowLine.getForeign("ID_JOURNAL");
            Cell cellJrnl = row.createCell(1);
            cellJrnl.setCellValue(StringUtils.toAsciiString(rowJrnl.getString("CODE").trim()));
            SQLRowAccessor rowValsSource = null;
            SQLRowAccessor rowMvt = rowLine.getForeign("ID_MOUVEMENT");
            if (rowMvt.getString("SOURCE").equals("AVOIR_CLIENT")) {
                rowValsSource = this.mapAvoir.get(rowMvt.getInt("IDSOURCE"));
            } else if (rowMvt.getString("SOURCE").equals("SAISIE_VENTE_FACTURE")) {
                rowValsSource = this.mapFacture.get(rowMvt.getInt("IDSOURCE"));
            }
            Cell cellPiece = row.createCell(2);
            if (rowValsSource != null) {
                cellPiece.setCellValue(StringUtils.toAsciiString(rowValsSource.getString("NUMERO")));
            }
            Cell cellRef = row.createCell(3);
            cellRef.setCellValue("");
            String cpt = rowLine.getForeign("ID_COMPTE_PCE").getString("NUMERO").trim();
            Cell cellCpt = row.createCell(4, CellType.STRING);
            cellCpt.setCellValue(this.getFormattedCompte(cpt));
            Cell cellCodeClient = row.createCell(5);
            if (containsCodeClient) {
                String codeClient = "";
                if (cpt.startsWith("41")) {
                    codeClient = rowLine.getString("CODE_CLIENT");
                }
                cellCodeClient.setCellValue(StringUtils.toAsciiString(codeClient));
            }
            Cell cellLib = row.createCell(6);
            cellLib.setCellValue(StringUtils.toAsciiString(rowLine.getString("NOM").trim()));
            Cell cellDateEch = row.createCell(7);
            Cell cellTypeRegl = row.createCell(8);
            if (rowValsSource != null && cpt.startsWith("41")) {
                SQLRowAccessor foreignMdr = rowValsSource.getForeign("ID_MODE_REGLEMENT");
                Date ech = ModeDeReglementSQLElement.calculDate(foreignMdr, rowValsSource.getDate("DATE").getTime());
                cellDateEch.setCellValue(ech);
                cellDateEch.setCellStyle((CellStyle)cellStyle);
                cellTypeRegl.setCellValue(foreignMdr.getForeign("ID_TYPE_REGLEMENT").getString("NOM"));
            }
            Cell cellDebit = row.createCell(9);
            Long debit = rowLine.getLong("DEBIT");
            cellDebit.setCellValue((double)debit.longValue() / 100.0);
            Long credit = rowLine.getLong("CREDIT");
            Cell cellCredit = row.createCell(10);
            cellCredit.setCellValue((double)credit.longValue() / 100.0);
            Cell cellDebAbo = row.createCell(11);
            Cell cellFinAbo = row.createCell(12);
            if (rowValsSource != null && rowValsSource.contains("ID_ABONNEMENT") && rowValsSource.getTable().getName().equals("SAISIE_VENTE_FACTURE") && cpt.startsWith("41") && (rowValsAbo = rowValsSource.getForeign("ID_ABONNEMENT")) != null && !rowValsAbo.isUndefined()) {
                Calendar calFin;
                Calendar calDeb = rowValsAbo.getDate("DATE_DEBUT_FACTURE");
                if (calDeb != null) {
                    cellDebAbo.setCellValue(calDeb.getTime());
                    cellDebAbo.setCellStyle((CellStyle)cellStyle);
                }
                if ((calFin = rowValsAbo.getDate("DATE_FIN_FACTURE")) != null) {
                    cellFinAbo.setCellValue(calFin.getTime());
                    cellFinAbo.setCellStyle((CellStyle)cellStyle);
                }
            }
            ++i;
        }
        workBook.write(bufOut);
        workBook.close();
    }

    private void exportTAB(OutputStream bufOut) throws IOException {
        List<SQLRowValues> l = this.data;
        boolean containsCodeClient = this.getEcritureT().contains("CODE_CLIENT");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        int size = l.size();
        int i = 0;
        while (i < size) {
            StringBuilder line = new StringBuilder();
            SQLRowValues rowLine = l.get(i);
            Date d = rowLine.getDate("DATE").getTime();
            line.append(dateFormat.format(d));
            line.append('\t');
            SQLRowAccessor rowJrnl = rowLine.getForeign("ID_JOURNAL");
            line.append(StringUtils.toAsciiString(rowJrnl.getString("CODE").trim()));
            line.append('\t');
            SQLRowAccessor rowValsSource = null;
            SQLRowAccessor rowMvt = rowLine.getForeign("ID_MOUVEMENT");
            if (rowMvt.getString("SOURCE").equals("AVOIR_CLIENT")) {
                rowValsSource = this.mapAvoir.get(rowMvt.getInt("IDSOURCE"));
            } else if (rowMvt.getString("SOURCE").equals("SAISIE_VENTE_FACTURE")) {
                rowValsSource = this.mapFacture.get(rowMvt.getInt("IDSOURCE"));
            }
            if (rowValsSource != null) {
                line.append(StringUtils.toAsciiString(rowValsSource.getString("NUMERO")));
            }
            line.append('\t');
            line.append('\t');
            String cpt = rowLine.getForeign("ID_COMPTE_PCE").getString("NUMERO").trim();
            line.append(this.getFormattedCompte(cpt));
            line.append('\t');
            if (containsCodeClient) {
                String codeClient = "";
                if (cpt.startsWith("41")) {
                    codeClient = rowLine.getString("CODE_CLIENT");
                }
                line.append(StringUtils.toAsciiString(codeClient));
                line.append('\t');
            }
            line.append(StringUtils.toAsciiString(rowLine.getString("NOM").trim()));
            line.append('\t');
            if (rowValsSource != null && cpt.startsWith("41")) {
                SQLRowAccessor foreignMdr = rowValsSource.getForeign("ID_MODE_REGLEMENT");
                Date ech = ModeDeReglementSQLElement.calculDate(foreignMdr, rowValsSource.getDate("DATE").getTime());
                line.append(dateFormat.format(ech));
                line.append('\t');
                line.append(foreignMdr.getForeign("ID_TYPE_REGLEMENT").getString("NOM"));
                line.append('\t');
            } else {
                line.append('\t');
                line.append('\t');
            }
            Long debit = rowLine.getLong("DEBIT");
            line.append(GestionDevise.currencyToString(debit, false));
            line.append('\t');
            Long credit = rowLine.getLong("CREDIT");
            line.append(GestionDevise.currencyToString(credit, false));
            line.append('\t');
            if (rowValsSource != null && rowValsSource.contains("ID_ABONNEMENT") && rowValsSource.getTable().getName().equals("ID_SAISIE_VENTE_FACTURE") && cpt.startsWith("41")) {
                SQLRowAccessor rowValsAbo = rowValsSource.getForeign("ID_ABONNEMENT");
                if (rowValsAbo != null && !rowValsAbo.isUndefined()) {
                    Calendar calDeb = rowValsAbo.getDate("DATE_DEBUT_FACTURE");
                    if (calDeb != null) {
                        line.append(dateFormat.format(calDeb.getTime()));
                    }
                    line.append('\t');
                    Calendar calFin = rowValsAbo.getDate("DATE_FIN_FACTURE");
                    if (calFin != null) {
                        line.append(dateFormat.format(calFin.getTime()));
                    }
                    line.append('\t');
                }
            } else {
                line.append('\t');
                line.append('\t');
            }
            line.append('\r');
            line.append('\n');
            bufOut.write(line.toString().getBytes(StringUtils.Cp1252));
            ++i;
        }
    }
}

