/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.Dependency;
import org.openconcerto.erp.modules.ModulePreferencePanel;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.preferences.SQLPreferences;

@ThreadSafe
public abstract class ModuleFactory {
    public static final String NAME_KEY = "name";
    public static final String DESC_KEY = "description";
    private final ModuleReference ref;
    private final String contact;

    protected static final Map<Object, Dependency> createMap(List<Dependency> l) {
        if (l == null || l.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Dependency> res = new LinkedHashMap<Object, Dependency>(l.size());
        for (Dependency d : l) {
            res.put(String.valueOf(res.size()), d);
        }
        return res;
    }

    protected ModuleFactory(ModuleReference ref, String contact) {
        if (ref.getVersion() == null) {
            throw new IllegalArgumentException("No version " + ref);
        }
        this.ref = ref;
        this.contact = contact;
    }

    public final ModuleReference getReference() {
        return this.ref;
    }

    public final String getID() {
        return this.getReference().getID();
    }

    public final String getContact() {
        return this.contact;
    }

    public final ModuleVersion getVersion() {
        return this.getReference().getVersion();
    }

    public final int getMajorVersion() {
        return this.getVersion().getMajor();
    }

    public final int getMinorVersion() {
        return this.getVersion().getMinor();
    }

    protected abstract Map<Object, Dependency> getDependencies();

    public final boolean conflictsWith(ModuleFactory f) {
        if (this.getID().equals(f.getID())) {
            return !this.equals(f);
        }
        return this.conflictsWithOtherID(f) || f.conflictsWithOtherID(this);
    }

    protected boolean conflictsWithOtherID(ModuleFactory f) {
        return false;
    }

    public final boolean conflictsWith(Collection<ModuleFactory> factories) {
        boolean res = false;
        Iterator<ModuleFactory> iter = factories.iterator();
        while (iter.hasNext() && !res) {
            ModuleFactory f = iter.next();
            res = this.conflictsWith(f);
        }
        return res;
    }

    protected abstract ResourceBundle getResourceBundle();

    public final String getName() {
        return this.getResourceBundle().getString(NAME_KEY);
    }

    public final String getDescription() {
        return this.getResourceBundle().getString(DESC_KEY);
    }

    public abstract AbstractModule createModule(File var1, Map<Object, AbstractModule> var2) throws Exception;

    protected final synchronized AbstractModule createModule(Class<?> c, File localDir) throws Exception {
        AbstractModule res = (AbstractModule)c.getConstructor(ModuleFactory.class).newInstance(this);
        res.setLocalDirectory(localDir);
        return res;
    }

    public final Preferences getLocalPreferences() {
        return this.getPreferences(true, null);
    }

    public final Preferences getSQLPreferences(DBRoot root) {
        return this.getPreferences(false, root);
    }

    public final Preferences getPreferences(boolean local, DBRoot root) {
        Preferences rootPrefs = local ? Preferences.userRoot() : new SQLPreferences(root);
        return rootPrefs.node(String.valueOf(ModulePreferencePanel.getAppPrefPath()) + this.getID().replace('.', '/'));
    }

    public String toString() {
        String className;
        String string = className = this.getClass().isAnonymousClass() ? this.getClass().getName() : this.getClass().getSimpleName();
        assert (className.length() > 0);
        return String.valueOf(className) + " " + this.getID() + " (" + this.getMajorVersion() + "." + this.getMinorVersion() + ")";
    }
}

