/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.modules.DepLink;
import org.openconcerto.erp.modules.Dependency;
import org.openconcerto.erp.modules.DependencyGraph;
import org.openconcerto.erp.modules.ModuleFactory;

public final class DepSolverGraph {
    private final ModuleFactory root;
    private final boolean virtualRoot;
    private final List<String> rootIDs;
    private final DependencyGraph graph;
    private final Set<ModuleFactory> solving = new HashSet<ModuleFactory>();
    private final Set<ModuleFactory> solved;
    private boolean frozen = false;

    DepSolverGraph(ModuleFactory root, boolean virtualRoot, DependencyGraph currentGraph) {
        if (root == null) {
            throw new NullPointerException("Null root");
        }
        this.root = root;
        this.virtualRoot = virtualRoot;
        if (!virtualRoot) {
            this.rootIDs = Collections.singletonList(this.root.getID());
        } else {
            ArrayList<String> l = new ArrayList<String>();
            for (Dependency d : this.root.getDependencies().values()) {
                l.addAll(d.getRequiredIDs());
            }
            this.rootIDs = Collections.unmodifiableList(l);
        }
        this.graph = new DependencyGraph(currentGraph);
        this.solved = new HashSet(this.graph.vertexSet());
    }

    private DepSolverGraph(DepSolverGraph o) {
        this.root = o.root;
        this.virtualRoot = o.virtualRoot;
        this.rootIDs = o.rootIDs;
        this.graph = new DependencyGraph(o.graph);
        this.solved = new HashSet<ModuleFactory>(o.solved);
        for (ModuleFactory f : o.solving) {
            if (!this.graph.vertexSet().contains(f)) continue;
            this.removeRec(f);
        }
    }

    final DepSolverGraph copyAndRemove(Set<ModuleFactory> toRemove) {
        DepSolverGraph res = new DepSolverGraph(this);
        for (ModuleFactory f : toRemove) {
            if (!res.graph.vertexSet().contains(f)) continue;
            res.removeRec(f);
        }
        return res;
    }

    private void removeRec(ModuleFactory f) {
        this.checkFrozen();
        this.solved.remove(f);
        this.solving.remove(f);
        HashSet incomingEdges = new HashSet(this.graph.incomingEdgesOf(f));
        this.graph.removeVertex(f);
        for (DepLink l : incomingEdges) {
            ModuleFactory src = (ModuleFactory)l.getSource();
            assert (l.getTarget() == f);
            this.removeRec(src);
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    private final void checkFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("this has been frozen: " + this);
        }
    }

    public final List<String> getRootIDs() {
        return this.rootIDs;
    }

    public final Set<String> getIDs() {
        return this.graph.idSet();
    }

    public final void addSolving(ModuleFactory src, Object depID, ModuleFactory target) {
        this.checkFrozen();
        if (src != null && this.getState(src) != NodeState.SOLVING) {
            throw new IllegalArgumentException("Source isn't solving : " + src);
        }
        if (this.getState(target) != NodeState.NOT_SOLVING) {
            throw new IllegalArgumentException("Target isn't NOT_SOLVING : " + target);
        }
        this.solving.add(target);
        this.graph.addVertex(target);
        if (src != null) {
            this.graph.addEdge(src, depID, target);
        } else assert (target == this.root);
    }

    public final void setSolved(ModuleFactory f) {
        this.checkFrozen();
        if (this.getState(f) != NodeState.SOLVING) {
            throw new IllegalArgumentException("Not SOLVING : " + f);
        }
        this.solving.remove(f);
        this.solved.add(f);
    }

    public final void addDependency(ModuleFactory src, Object depID, ModuleFactory target) {
        this.checkFrozen();
        if (this.getState(src) != NodeState.SOLVING) {
            throw new IllegalArgumentException("Source isn't solving : " + src);
        }
        if (this.getState(target) != NodeState.SOLVED) {
            throw new IllegalArgumentException("Target isn't SOLVED : " + target);
        }
        this.graph.addEdge(src, depID, target);
    }

    public final NodeState getState(ModuleFactory f) {
        if (f == null) {
            throw new NullPointerException();
        }
        if (!this.graph.containsVertex(f)) {
            return NodeState.NOT_SOLVING;
        }
        if (this.solved.contains(f)) {
            return NodeState.SOLVED;
        }
        if (this.solving.contains(f)) {
            return NodeState.SOLVING;
        }
        throw new IllegalStateException("Factory is in graph but neither solving nor solved : " + f);
    }

    public final boolean isSolved() {
        return this.graph.vertexSet().size() == this.solved.size();
    }

    public final Set<ModuleFactory> getConflicts(ModuleFactory f) {
        HashSet<ModuleFactory> res = new HashSet<ModuleFactory>();
        for (ModuleFactory in : this.graph.vertexSet()) {
            if (!f.conflictsWith(in)) continue;
            res.add(in);
        }
        return res;
    }

    public final ModuleFactory getPreviousSolving(ModuleFactory f) {
        if (this.getState(f) != NodeState.SOLVING) {
            throw new IllegalArgumentException("Not SOLVING : " + f);
        }
        Set incomingEdges = this.graph.incomingEdgesOf(f);
        if (incomingEdges.size() != 1) {
            throw new IllegalStateException("Not 1 previous : " + incomingEdges);
        }
        ModuleFactory res = (ModuleFactory)((DepLink)incomingEdges.iterator().next()).getSource();
        return this.getState(res) == NodeState.SOLVING ? res : null;
    }

    public ModuleFactory getDependency(ModuleFactory f, Object id) {
        for (DepLink l : this.graph.outgoingEdgesOf(f)) {
            if (!l.getDepID().equals(id)) continue;
            return (ModuleFactory)l.getTarget();
        }
        return null;
    }

    public final Map<Object, ModuleFactory> getDependencies(ModuleFactory f) {
        return this.getDependencies(f, null);
    }

    public final Map<Object, ModuleFactory> getDependencies(ModuleFactory f, NodeState state) {
        Set outgoingEdges = this.graph.outgoingEdgesOf(f);
        HashMap<Object, ModuleFactory> res = new HashMap<Object, ModuleFactory>(outgoingEdges.size());
        for (DepLink l : outgoingEdges) {
            if (state != null && this.getState((ModuleFactory)l.getTarget()) != state) continue;
            res.put(l.getDepID(), (ModuleFactory)l.getTarget());
        }
        return res;
    }

    public List<ModuleFactory> flatten() throws IllegalStateException {
        if (!this.isSolved()) {
            throw new IllegalStateException("Not all solved");
        }
        ArrayList<ModuleFactory> res = new ArrayList<ModuleFactory>(this.solved.size());
        this.walk(this.root, res);
        assert (this.root == res.get(res.size() - 1));
        if (this.virtualRoot) {
            res.remove(res.size() - 1);
        }
        return res;
    }

    private void walk(ModuleFactory node, List<ModuleFactory> res) {
        if (!res.contains(node)) {
            for (DepLink l : this.graph.outgoingEdgesOf(node)) {
                this.walk((ModuleFactory)l.getTarget(), res);
            }
            res.add(node);
        }
    }

    public final Set<ModuleFactory> getFactories() {
        return this.getFactories(false);
    }

    public final Set<ModuleFactory> getFactories(boolean includeVirtual) {
        Set res = this.graph.vertexSet();
        if (this.virtualRoot && !includeVirtual) {
            res = new HashSet(res);
            res.remove(this.root);
        }
        return Collections.unmodifiableSet(res);
    }

    public String toString() {
        String rootS = this.root + (this.virtualRoot ? " (virtual)" : "");
        String solvingS = "\nSolving  " + this.solving;
        String solvedS = "\nSolved : " + this.solved;
        String graphS = "\nGraph : " + this.graph;
        return String.valueOf(this.getClass().getSimpleName()) + " " + rootS + solvedS + solvingS + graphS;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.graph.hashCode();
        result = 31 * result + this.root.hashCode();
        result = 31 * result + (this.virtualRoot ? 1231 : 1237);
        result = 31 * result + this.solved.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DepSolverGraph other = (DepSolverGraph)obj;
        return this.root.equals(other.root) && this.virtualRoot == other.virtualRoot && this.solved.equals(other.solved) && this.solving.equals(other.solving) && this.graph.equals(other.graph);
    }

    public static enum NodeState {
        NOT_SOLVING,
        SOLVING,
        SOLVED;

    }
}

