/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class FactureBonSQLInjector
extends SQLInjector {
    public FactureBonSQLInjector(DBRoot root) {
        super(root, "SAISIE_VENTE_FACTURE", "BON_DE_LIVRAISON", true);
        SQLTable tableFacture = this.getSource();
        SQLTable tableBon = this.getDestination();
        this.map(tableFacture.getField("ID_CLIENT"), tableBon.getField("ID_CLIENT"));
        this.mapDefaultValues(tableBon.getField("SOURCE"), tableFacture.getName());
        this.map(tableFacture.getKey(), tableBon.getField("IDSOURCE"));
        if (tableFacture.contains("ID_POLE_PRODUIT") && tableBon.contains("ID_POLE_PRODUIT")) {
            this.map(tableFacture.getField("ID_POLE_PRODUIT"), tableBon.getField("ID_POLE_PRODUIT"));
        }
        if (this.getSource().getTable().contains("ID_CONTACT") && this.getDestination().getTable().contains("ID_CONTACT")) {
            this.map(this.getSource().getField("ID_CONTACT"), this.getDestination().getField("ID_CONTACT"));
        }
        if (this.getSource().getTable().contains("ID_CLIENT_DEPARTEMENT")) {
            this.map(this.getSource().getField("ID_CLIENT_DEPARTEMENT"), this.getDestination().getField("ID_CLIENT_DEPARTEMENT"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("BON_DE_LIVRAISON_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_BON_DE_LIVRAISON");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_BON_DE_LIVRAISON", "NOM", "NOM");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_BON_DE_LIVRAISON", "INFOS", "INFOS");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_BON_DE_LIVRAISON", (Object)rowVals);
            }
        }
    }
}

