/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.util.List;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class RefClientValueProvider
implements SpreadSheetCellValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor rowAff;
        SQLRowAccessor row = context.getRow();
        String ref = row.getString("REF_CLIENT");
        if (!(ref != null && ref.trim().length() != 0 || (rowAff = row.getForeign("ID_AFFAIRE")) == null || rowAff.isUndefined())) {
            SQLRowValues rowVals = new SQLRowValues(row.getTable().getTable("AFFAIRE_ELEMENT"));
            rowVals.put("SITUATION_ADMIN", null);
            SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
            fetch.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.andWhere(new Where(input.getTableRef("AFFAIRE_ELEMENT").getField("ID_AFFAIRE"), "=", rowAff.getID()));
                    return input;
                }
            });
            List<SQLRowValues> result = fetch.fetch();
            for (SQLRowValues sqlRowValues : result) {
                String string = sqlRowValues.getString("SITUATION_ADMIN");
                if (string == null || string.trim().length() <= 0) continue;
                ref = String.valueOf(ref) + string + ",";
            }
        }
        return ref;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("affaire.customer.ref", new RefClientValueProvider());
    }
}

