/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import com.ibm.icu.math.BigDecimal;
import java.util.List;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;

public class FichePayeSmicHProvider
implements SpreadSheetCellValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLTable tableVar = context.getRow().getTable().getDBRoot().findTable("VARIABLE_PAYE");
        List<SQLRow> rows = SQLBackgroundTableCache.getInstance().getCacheForTable(tableVar).getRows();
        for (SQLRow sqlRow : rows) {
            if (!sqlRow.getString("NOM").equals("SMIC")) continue;
            return new BigDecimal(sqlRow.getFloat("VALEUR"));
        }
        BigDecimal smic = new BigDecimal(10.03);
        return smic;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("fichepaye.smic", new FichePayeSmicHProvider());
    }
}

