/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.StringUtils;

public class SpreadSheetCellValueContext {
    private SQLRowAccessor row;
    private Map<String, String> map = new HashMap<String, String>();

    public SpreadSheetCellValueContext(SQLRowAccessor row) {
        this.row = row;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream prt) {
        prt.println("Row id: " + this.row.getID() + " table: " + this.row.getTable().getName());
        ArrayList<String> fields = new ArrayList<String>();
        fields.addAll(this.row.getFields());
        Collections.sort(fields);
        for (String field : fields) {
            prt.print(StringUtils.rightAlign(field, 30));
            prt.print(" : ");
            prt.println(this.row.getObject(field));
        }
        prt.println("Parameters:");
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(this.map.keySet());
        Collections.sort(params);
        for (String param : params) {
            prt.print(StringUtils.rightAlign(param, 30));
            prt.print(" : ");
            prt.println(this.map.get(param));
        }
    }

    public SQLRowAccessor getRow() {
        return this.row;
    }

    public void put(String name, String value) {
        this.map.put(name, value);
    }

    public Object get(String name) {
        return this.map.get(name);
    }
}

